/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.NameIDFormat;
import dk.itst.oiosaml.sp.model.OIORequest;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.util.Utils;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.validation.ValidationException;

public class OIOAuthnRequest
extends OIORequest {
    private static final Logger log = LoggerFactory.getLogger(OIOAuthnRequest.class);
    private final AuthnRequest request;
    private final String relayState;

    public OIOAuthnRequest(AuthnRequest request, String relayState) {
        super((RequestAbstractType)request);
        this.request = request;
        this.relayState = relayState;
    }

    public static OIOAuthnRequest buildAuthnRequest(String ssoServiceLocation, String spEntityId, String protocolBinding, SessionHandler handler, String relayState, String assertionConsumerUrl) {
        AuthnRequest authnRequest = SAMLUtil.buildXMLObject(AuthnRequest.class);
        authnRequest.setIssuer(SAMLUtil.createIssuer(spEntityId));
        authnRequest.setID(Utils.generateUUID());
        authnRequest.setForceAuthn(Boolean.FALSE);
        authnRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        authnRequest.setProtocolBinding(protocolBinding);
        authnRequest.setDestination(ssoServiceLocation);
        authnRequest.setAssertionConsumerServiceURL(assertionConsumerUrl);
        try {
            if (log.isDebugEnabled()) {
                log.debug("Validate the authnRequest...");
            }
            authnRequest.validate(true);
            if (log.isDebugEnabled()) {
                log.debug("...OK");
            }
        }
        catch (ValidationException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        return new OIOAuthnRequest(authnRequest, relayState);
    }

    public String getRedirectURL(Credential signingCredential) {
        OIORequest.Encoder enc = new OIORequest.Encoder(this);
        try {
            return enc.buildRedirectURL(signingCredential, this.getRelayState());
        }
        catch (MessageEncodingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
    }

    public void setNameIDPolicy(String format, boolean allowCreate) {
        if (format == null || format.trim().equals("")) {
            return;
        }
        NameIDFormat idFormat = NameIDFormat.valueOf(format.toUpperCase());
        NameIDPolicy policy = SAMLUtil.buildXMLObject(NameIDPolicy.class);
        policy.setAllowCreate(Boolean.valueOf(allowCreate));
        policy.setFormat(idFormat.getFormat());
        policy.setSPNameQualifier(this.request.getIssuer().getValue());
        this.request.setNameIDPolicy(policy);
    }

    public String getRelayState() {
        return this.relayState;
    }

    public boolean isForceAuthn() {
        return this.request.isForceAuthn() != null && this.request.isForceAuthn() != false;
    }

    public void setForceAuthn(boolean forceAuthn) {
        this.request.setForceAuthn(Boolean.valueOf(forceAuthn));
    }

    public void setPasive(boolean passive) {
        this.request.setIsPassive(Boolean.valueOf(passive));
    }

    public boolean isPassive() {
        return this.request.isPassive() != null && this.request.isPassive() != false;
    }
}

