/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.common.OIOSAMLConstants;
import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.OIORequest;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.util.Utils;
import dk.itst.oiosaml.sp.util.LogoutRequestValidationException;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.saml2.binding.decoding.HTTPRedirectDeflateDecoder;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.validation.ValidationException;

public class OIOLogoutRequest
extends OIORequest {
    private static final Logger log = LoggerFactory.getLogger(OIOLogoutRequest.class);
    private final LogoutRequest request;

    public OIOLogoutRequest(LogoutRequest request) {
        super((RequestAbstractType)request);
        this.request = request;
    }

    public static OIOLogoutRequest fromRedirectRequest(HttpServletRequest request) {
        BasicSAMLMessageContext<LogoutRequest, ?, ?> messageContext = OIOLogoutRequest.getMessageContextFromRequest(request);
        HTTPRedirectDeflateDecoder decoder = new HTTPRedirectDeflateDecoder();
        try {
            decoder.decode(messageContext);
        }
        catch (MessageDecodingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        catch (SecurityException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        return new OIOLogoutRequest((LogoutRequest)messageContext.getInboundSAMLMessage());
    }

    public static OIOLogoutRequest fromPostRequest(HttpServletRequest request) {
        BasicSAMLMessageContext<LogoutRequest, ?, ?> messageContext = OIOLogoutRequest.getMessageContextFromRequest(request);
        HTTPPostDecoder decoder = new HTTPPostDecoder();
        try {
            decoder.decode(messageContext);
        }
        catch (MessageDecodingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        catch (SecurityException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        return new OIOLogoutRequest((LogoutRequest)messageContext.getInboundSAMLMessage());
    }

    private static BasicSAMLMessageContext<LogoutRequest, ?, ?> getMessageContextFromRequest(HttpServletRequest request) {
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(request));
        return messageContext;
    }

    public String getSessionIndex() {
        String retVal = null;
        if (this.request.getSessionIndexes() != null && this.request.getSessionIndexes().size() > 0) {
            SessionIndex sessionIndexStructure = (SessionIndex)this.request.getSessionIndexes().get(0);
            retVal = sessionIndexStructure.getSessionIndex();
        }
        return retVal;
    }

    public boolean isSessionIndexOK(String sessionIndex) {
        String sessionIndex2 = this.getSessionIndex();
        return sessionIndex2 != null && sessionIndex2.equals(sessionIndex);
    }

    public void validateRequest(String signature, String queryString, PublicKey publicKey, String destination, String issuer) throws LogoutRequestValidationException {
        this.validateRequest(signature, queryString, Collections.singletonList(publicKey), destination, issuer);
    }

    public void validateRequest(String signature, String queryString, Collection<PublicKey> keys, String destination, String issuer) throws LogoutRequestValidationException {
        ArrayList<String> errors = new ArrayList<String>();
        this.validateRequest(issuer, destination, keys, errors);
        if (signature != null) {
            boolean valid = false;
            for (PublicKey publicKey : keys) {
                if (!Utils.verifySignature(signature, queryString, "SAMLRequest", publicKey)) continue;
                valid = true;
            }
            if (!valid) {
                errors.add("Invalid signature");
            }
        }
        if (this.request.getNotOnOrAfter() != null && !this.request.getNotOnOrAfter().isAfterNow()) {
            errors.add("LogoutRequest is expired. NotOnOrAfter; " + this.request.getNotOnOrAfter());
        }
        if (!errors.isEmpty()) {
            throw new LogoutRequestValidationException(errors);
        }
    }

    public static OIOLogoutRequest buildLogoutRequest(HttpSession session, String logoutServiceLocation, String issuerEntityId, SessionHandler handler) {
        LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject();
        logoutRequest.setID(Utils.generateUUID());
        logoutRequest.setIssueInstant(new DateTime(DateTimeZone.UTC));
        logoutRequest.addNamespace(OIOSAMLConstants.SAML20_NAMESPACE);
        logoutRequest.setDestination(logoutServiceLocation);
        logoutRequest.setReason("urn:oasis:names:tc:SAML:2.0:logout:user");
        logoutRequest.setIssuer(SAMLUtil.createIssuer(issuerEntityId));
        OIOAssertion assertion = handler.getAssertion(session.getId());
        if (assertion != null) {
            NameID nameID = SAMLUtil.createNameID(assertion.getSubjectNameIDValue());
            nameID.setFormat(assertion.getAssertion().getSubject().getNameID().getFormat());
            logoutRequest.setNameID(nameID);
            SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
            logoutRequest.getSessionIndexes().add(sessionIndex);
            sessionIndex.setSessionIndex(assertion.getSessionIndex());
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Validate the logoutRequest...");
            }
            logoutRequest.validate(true);
            if (log.isDebugEnabled()) {
                log.debug("...OK");
            }
        }
        catch (ValidationException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        return new OIOLogoutRequest(logoutRequest);
    }

    public String getRedirectRequestURL(Credential signingCredential) {
        OIORequest.Encoder enc = new OIORequest.Encoder(this);
        try {
            return enc.buildRedirectURL(signingCredential, null);
        }
        catch (MessageEncodingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
    }

    public void setReason(String reason) {
        this.request.setReason(reason);
    }
}

