/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.OIOAbstractResponse;
import dk.itst.oiosaml.sp.model.OIOLogoutRequest;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import dk.itst.oiosaml.sp.service.util.Utils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.saml2.binding.decoding.HTTPPostDecoder;
import org.opensaml.saml2.binding.decoding.HTTPRedirectDeflateDecoder;
import org.opensaml.saml2.binding.encoding.HTTPRedirectDeflateEncoder;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.util.URLBuilder;
import org.opensaml.ws.message.MessageContext;
import org.opensaml.ws.message.decoder.MessageDecodingException;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.ws.transport.InTransport;
import org.opensaml.ws.transport.http.HttpServletRequestAdapter;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.SecurityConfiguration;
import org.opensaml.xml.security.SecurityException;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.Pair;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Node;

public class OIOLogoutResponse
extends OIOAbstractResponse {
    private static final Logger log = LoggerFactory.getLogger(OIOLogoutResponse.class);
    private final LogoutResponse response;

    public OIOLogoutResponse(LogoutResponse response) {
        super((StatusResponseType)response);
        this.response = response;
    }

    public static OIOLogoutResponse fromRequest(OIOLogoutRequest request, String statusCode, String consent, String entityId, String destination) {
        LogoutResponse logoutResponse = SAMLUtil.buildXMLObject(LogoutResponse.class);
        logoutResponse.setID(Utils.generateUUID());
        logoutResponse.setIssueInstant(new DateTime(DateTimeZone.UTC));
        logoutResponse.setVersion(SAMLVersion.VERSION_20);
        logoutResponse.setStatus(SAMLUtil.createStatus(statusCode != null ? statusCode : "urn:oasis:names:tc:SAML:2.0:status:Success"));
        if (request != null) {
            logoutResponse.setInResponseTo(request.getID());
        }
        logoutResponse.setIssuer(SAMLUtil.createIssuer(entityId));
        logoutResponse.setDestination(destination);
        if (consent != null) {
            logoutResponse.setConsent(consent);
        }
        if (statusCode != null && !"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
            log.error("Invalid <LogoutRequest>: " + consent);
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Validate the logoutResponse...");
            }
            logoutResponse.validate(true);
            if (log.isDebugEnabled()) {
                log.debug("...OK");
            }
        }
        catch (org.opensaml.xml.validation.ValidationException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        return new OIOLogoutResponse(logoutResponse);
    }

    public static OIOLogoutResponse fromPostRequest(HttpServletRequest request) {
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(request));
        try {
            HTTPPostDecoder decoder = new HTTPPostDecoder();
            decoder.decode((MessageContext)messageContext);
        }
        catch (MessageDecodingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        catch (SecurityException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        LogoutResponse logoutResponse = (LogoutResponse)messageContext.getInboundSAMLMessage();
        OIOLogoutResponse res = new OIOLogoutResponse(logoutResponse);
        if (log.isDebugEnabled()) {
            log.debug("Received response: " + res.toXML());
        }
        return res;
    }

    public static OIOLogoutResponse fromHttpRedirect(HttpServletRequest request) {
        BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
        messageContext.setInboundMessageTransport((InTransport)new HttpServletRequestAdapter(request));
        try {
            HTTPRedirectDeflateDecoder decoder = new HTTPRedirectDeflateDecoder();
            decoder.decode((MessageContext)messageContext);
        }
        catch (MessageDecodingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        catch (SecurityException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        LogoutResponse logoutResponse = (LogoutResponse)messageContext.getInboundSAMLMessage();
        OIOLogoutResponse res = new OIOLogoutResponse(logoutResponse);
        if (log.isDebugEnabled()) {
            log.debug("Received response: " + res.toXML());
        }
        return res;
    }

    public String getRedirectURL(Credential signingCredential, String relayState) {
        Encoder enc = new Encoder();
        if (log.isDebugEnabled()) {
            log.debug("Setting RelayState..:" + relayState);
        }
        try {
            return this.buildRedirectURL(enc.deflateAndBase64Encode((SAMLObject)this.response), relayState, signingCredential);
        }
        catch (MessageEncodingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
    }

    private String buildRedirectURL(String message, String relayState, Credential signingCredential) throws MessageEncodingException {
        if (log.isDebugEnabled()) {
            log.debug("Building URL to redirect client to: " + this.response.getDestination());
        }
        URLBuilder urlBuilder = new URLBuilder(this.response.getDestination());
        List queryParams = urlBuilder.getQueryParams();
        queryParams.clear();
        queryParams.add(new Pair((Object)"SAMLResponse", (Object)message));
        if (relayState != null) {
            queryParams.add(new Pair((Object)"RelayState", (Object)relayState));
        }
        Encoder enc = new Encoder();
        if (signingCredential != null) {
            queryParams.add(new Pair((Object)"SigAlg", (Object)enc.getSignatureAlgorithmURI(signingCredential, null)));
            String sigMaterial = urlBuilder.buildQueryString();
            queryParams.add(new Pair((Object)"Signature", (Object)enc.generateSignature(signingCredential, enc.getSignatureAlgorithmURI(signingCredential, null), sigMaterial)));
        }
        return urlBuilder.buildURL();
    }

    public void validate(String requestId, String expectedDestination) throws ValidationException {
        try {
            this.response.validate(true);
        }
        catch (org.opensaml.xml.validation.ValidationException e) {
            log.error("Unable to validate message", e);
            throw new ValidationException((Exception)((Object)e));
        }
        this.validateResponse(requestId, expectedDestination, false);
    }

    public void validate(String requestId, String expectedDestination, String signature, String queryString, PublicKey key) {
        this.validate(requestId, expectedDestination, signature, queryString, Collections.singletonList(key));
    }

    public void validate(String requestId, String expectedDestination, String signature, String queryString, Collection<PublicKey> keys) {
        this.validate(requestId, expectedDestination);
        boolean valid = false;
        for (PublicKey key : keys) {
            if (!Utils.verifySignature(signature, queryString, "SAMLResponse", key)) continue;
            valid = true;
        }
        if (!valid) {
            throw new ValidationException("Invalid signature");
        }
        if (log.isDebugEnabled()) {
            log.debug("...signature OK");
        }
    }

    public void validate(String requestId, String expectedDestination, Collection<PublicKey> keys) {
        this.validate(requestId, expectedDestination);
        boolean valid = false;
        for (PublicKey key : keys) {
            if (!this.verifySignature(key)) continue;
            valid = true;
        }
        if (!valid) {
            throw new ValidationException("Invalid signature");
        }
        if (log.isDebugEnabled()) {
            log.debug("...signature OK");
        }
    }

    protected static class Encoder
    extends HTTPRedirectDeflateEncoder {
        protected Encoder() {
        }

        public String deflateAndBase64Encode(SAMLObject obj) throws MessageEncodingException {
            String messageStr = XMLHelper.nodeToString((Node)this.marshallMessage((XMLObject)obj));
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(8, true);
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);
            try {
                deflaterStream.write(messageStr.getBytes("UTF-8"));
                deflaterStream.finish();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to deflate message", e);
            }
            return Base64.encodeBytes((byte[])bytesOut.toByteArray(), (int)8);
        }

        protected String generateSignature(Credential signingCredential, String algorithmURI, String queryString) throws MessageEncodingException {
            return super.generateSignature(signingCredential, algorithmURI, queryString);
        }

        protected String getSignatureAlgorithmURI(Credential credential, SecurityConfiguration config) throws MessageEncodingException {
            return super.getSignatureAlgorithmURI(credential, config);
        }
    }
}

