/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.sp.model.OIOSamlObject;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import org.opensaml.common.SAMLObject;
import org.opensaml.common.binding.BasicSAMLMessageContext;
import org.opensaml.common.binding.SAMLMessageContext;
import org.opensaml.saml2.binding.encoding.HTTPRedirectDeflateEncoder;
import org.opensaml.saml2.core.RequestAbstractType;
import org.opensaml.ws.message.encoder.MessageEncodingException;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.util.Base64;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Node;

public abstract class OIORequest
extends OIOSamlObject {
    private final RequestAbstractType request;

    public OIORequest(RequestAbstractType request) {
        super((XMLObject)request);
        this.request = request;
    }

    public boolean isDestinationOK(String destination) {
        if (this.request.getDestination() == null) {
            return true;
        }
        return this.request.getDestination() != null && this.request.getDestination().equals(destination);
    }

    public boolean isIssuerOK(String issuer) {
        return this.request.getIssuer() != null && this.request.getIssuer().getValue() != null && this.request.getIssuer().getValue().equals(issuer);
    }

    protected final void validateRequest(String expectedIssuer, String expectedDestination, PublicKey publicKey, List<String> errors) {
        this.validateRequest(expectedIssuer, expectedDestination, Collections.singletonList(publicKey), errors);
    }

    protected final void validateRequest(String expectedIssuer, String expectedDestination, Collection<PublicKey> keys, List<String> errors) {
        try {
            this.request.validate(true);
        }
        catch (ValidationException e) {
            errors.add(e.getMessage());
        }
        if (!this.isDestinationOK(expectedDestination)) {
            errors.add("Wrong destination. Expected " + expectedDestination + " but was " + this.request.getDestination());
        }
        if (!this.isIssuerOK(expectedIssuer)) {
            errors.add("Wring issuer. Expected " + expectedIssuer + " but was " + this.request.getIssuer());
        }
        if (this.hasSignature()) {
            boolean valid = false;
            for (PublicKey key : keys) {
                if (!this.verifySignature(key)) continue;
                valid = true;
            }
            if (!valid) {
                errors.add("Invalid signature in SAMLObject");
            }
        }
    }

    public String getID() {
        return this.request.getID();
    }

    public String getIssuer() {
        return this.request.getIssuer() != null ? this.request.getIssuer().getValue() : null;
    }

    public String getDestination() {
        return this.request.getDestination();
    }

    protected class Encoder
    extends HTTPRedirectDeflateEncoder {
        protected Encoder() {
        }

        public String buildRedirectURL(Credential signingCredential, String relayState) throws MessageEncodingException {
            BasicSAMLMessageContext messageContext = new BasicSAMLMessageContext();
            messageContext.setOutboundSAMLMessage((SAMLObject)OIORequest.this.request);
            messageContext.setRelayState(relayState);
            messageContext.setOutboundSAMLMessageSigningCredential(signingCredential);
            String messageStr = XMLHelper.nodeToString((Node)this.marshallMessage((XMLObject)OIORequest.this.request));
            ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
            Deflater deflater = new Deflater(8, true);
            DeflaterOutputStream deflaterStream = new DeflaterOutputStream((OutputStream)bytesOut, deflater);
            try {
                deflaterStream.write(messageStr.getBytes("UTF-8"));
                deflaterStream.finish();
            }
            catch (IOException e) {
                throw new RuntimeException("Unable to deflate message", e);
            }
            String encoded = Base64.encodeBytes((byte[])bytesOut.toByteArray(), (int)8);
            return super.buildRedirectURL((SAMLMessageContext)messageContext, OIORequest.this.request.getDestination(), encoded);
        }
    }
}

