/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model;

import dk.itst.oiosaml.helper.DeveloperHelper;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.OIOAbstractResponse;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.OIOEncryptedAssertion;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import java.security.cert.Certificate;
import java.util.Collection;
import java.util.Collections;
import org.opensaml.saml2.core.Assertion;
import org.opensaml.saml2.core.EncryptedAssertion;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.Response;
import org.opensaml.saml2.core.StatusResponseType;
import org.opensaml.xml.security.credential.Credential;

public class OIOResponse
extends OIOAbstractResponse {
    private static final Logger log = LoggerFactory.getLogger(OIOResponse.class);
    private final Response response;
    private OIOAssertion assertion;

    public OIOResponse(Response response) {
        super((StatusResponseType)response);
        this.response = response;
    }

    public String getOriginatingIdpEntityId(SessionHandler handler) {
        if (this.response.getInResponseTo() == null) {
            Issuer issuer = null;
            if (!this.response.getAssertions().isEmpty()) {
                issuer = ((Assertion)this.response.getAssertions().get(0)).getIssuer();
            }
            if (issuer == null) {
                issuer = this.response.getIssuer();
            }
            if (issuer == null) {
                throw new ValidationException("SAML Response does not contain a issuer, this is required for unsolicited Responses");
            }
            return issuer.getValue();
        }
        return handler.removeEntityIdForRequest(this.response.getInResponseTo());
    }

    public void validateResponse(String expectedDestination, Certificate certificate, boolean allowPassive) throws ValidationException {
        this.validateResponse(expectedDestination, Collections.singletonList(certificate), allowPassive);
    }

    public void validateResponse(String expectedDestination, Collection<? extends Certificate> certificates, boolean allowPassive) throws ValidationException {
        this.validateResponse(null, expectedDestination, allowPassive);
        if (this.response.getAssertions().isEmpty() && !this.isPassive()) {
            throw new ValidationException("Response must contain an Assertion. If the Response contains an encrypted Assertion, decrypt it before calling validate.");
        }
        if (!this.hasSignature() && this.isPassive()) {
            return;
        }
        if (this.hasSignature() || this.isPassive()) {
            boolean valid = false;
            for (Certificate certificate : certificates) {
                if (!this.verifySignature(certificate.getPublicKey())) continue;
                valid = true;
            }
            if (!valid) {
                throw new ValidationException("The response is not signed correctly");
            }
        } else if (!this.response.getAssertions().isEmpty()) {
            boolean valid = false;
            if (certificates.size() == 0) {
                DeveloperHelper.log("It is not possible to validate the signature on the assertion, because there are no valid certificates to check the signature against. This might be because revocation checking has failed on the IdP certificates");
            }
            for (Certificate certificate : certificates) {
                if (!this.getAssertion().verifySignature(certificate.getPublicKey())) continue;
                valid = true;
            }
            if (!valid) {
                throw new ValidationException("The assertion is not signed correctly");
            }
        }
    }

    public OIOAssertion getAssertion() {
        if (this.assertion != null) {
            if (log.isDebugEnabled()) {
                log.debug("Found encrypted assertion, returning decrypted");
            }
            return this.assertion;
        }
        return OIOAssertion.fromResponse(this.response);
    }

    public void decryptAssertion(Credential credential, boolean allowUnencrypted) {
        if (this.response.getEncryptedAssertions().size() > 0) {
            OIOEncryptedAssertion enc = new OIOEncryptedAssertion((EncryptedAssertion)this.response.getEncryptedAssertions().get(0));
            this.assertion = enc.decryptAssertion(credential);
            this.response.getAssertions().add(this.assertion.getAssertion());
        } else if (!allowUnencrypted && !this.response.getAssertions().isEmpty()) {
            throw new ValidationException("Assertion is not encrypted");
        }
    }

    public Response getResponse() {
        return this.response;
    }

    public boolean isPassive() {
        if (this.response.getStatus() == null) {
            return false;
        }
        if (this.response.getStatus().getStatusCode() == null) {
            return false;
        }
        if (this.response.getStatus().getStatusCode().getStatusCode() == null) {
            return false;
        }
        return "urn:oasis:names:tc:SAML:2.0:status:NoPassive".equals(this.response.getStatus().getStatusCode().getStatusCode().getValue());
    }
}

