/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.model.validation;

import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.validation.AssertionValidator;
import dk.itst.oiosaml.sp.model.validation.ValidationException;
import org.joda.time.DateTime;
import org.opensaml.saml2.core.Assertion;

public class BasicAssertionValidator
implements AssertionValidator {
    @Override
    public void validate(OIOAssertion assertion, String spEntityId, String spAssertionConsumerURL) throws ValidationException {
        Assertion a = assertion.getAssertion();
        if (a.getIssueInstant() == null) {
            throw new ValidationException("The assertion must contain a IssueInstant");
        }
        if (a.getIssuer() == null || a.getIssuer().getValue() == null) {
            throw new ValidationException("The assertion must contain an Issuer");
        }
        if (assertion.getSubjectNameIDValue() == null) {
            throw new ValidationException("The assertion must contain a Subject/NameID");
        }
        if (!assertion.getAudience().contains(spEntityId)) {
            throw new ValidationException("The assertion must contain the service provider " + spEntityId + " within the Audience list: " + assertion.getAudience());
        }
        DateTime conditionTime = assertion.getConditionTime();
        if (conditionTime == null || !conditionTime.isAfterNow()) {
            throw new ValidationException("Condition NotOnOrAfter is after now: " + conditionTime);
        }
    }
}

