/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.model.OIOLogoutResponse;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LogoutHTTPResponseHandler
implements SAMLHandler {
    private static final long serialVersionUID = 2487601130738744767L;
    private static final Logger log = LoggerFactory.getLogger(LogoutHTTPResponseHandler.class);
    public static final String VERSION = "$Id: LogoutHTTPResponseHandler.java 2950 2008-05-28 08:22:34Z jre $";

    @Override
    public void handleGet(RequestContext ctx) throws ServletException, IOException {
        HttpServletRequest request = ctx.getRequest();
        HttpSession session = ctx.getSession();
        if (log.isDebugEnabled()) {
            log.debug("Calling URL.:" + request.getRequestURI() + "?" + request.getQueryString());
            log.debug("samlResponse...:" + request.getParameter("SAMLResponse"));
            log.debug("relayState....:" + request.getParameter("RelayState"));
            log.debug("sigAlg........:" + request.getParameter("SigAlg"));
            log.debug("signature.....:" + request.getParameter("Signature"));
        }
        OIOLogoutResponse logoutResponse = OIOLogoutResponse.fromHttpRedirect(request);
        Audit.log(Operation.LOGOUTREQUEST, false, logoutResponse.getInResponseTo(), logoutResponse.toXML());
        String idpEntityId = ctx.getSessionHandler().removeEntityIdForRequest(logoutResponse.getInResponseTo());
        IdpMetadata.Metadata metadata = ctx.getIdpMetadata().getMetadata(idpEntityId);
        logoutResponse.validate(null, ctx.getSpMetadata().getSingleLogoutServiceHTTPRedirectResponseLocation(), request.getParameter("Signature"), request.getQueryString(), metadata.getPublicKeys());
        ctx.getSessionHandler().logOut(session);
        Audit.log(Operation.LOGOUT, null);
        String homeUrl = ctx.getConfiguration().getString("oiosaml-sp.uri.home");
        if (log.isDebugEnabled()) {
            log.debug("sendRedirect to..:" + homeUrl);
        }
        if (homeUrl == null) {
            homeUrl = request.getContextPath();
        }
        ctx.getResponse().sendRedirect(homeUrl);
    }

    @Override
    public void handlePost(RequestContext ctx) throws ServletException, IOException {
        HttpServletRequest request = ctx.getRequest();
        HttpSession session = ctx.getSession();
        if (log.isDebugEnabled()) {
            log.debug("samlResponse...:" + request.getParameter("SAMLResponse"));
        }
        OIOLogoutResponse logoutResponse = OIOLogoutResponse.fromPostRequest(request);
        Audit.log(Operation.LOGOUTREQUEST, false, logoutResponse.getInResponseTo(), logoutResponse.toXML());
        String idpEntityId = ctx.getSessionHandler().removeEntityIdForRequest(logoutResponse.getInResponseTo());
        IdpMetadata.Metadata metadata = ctx.getIdpMetadata().getMetadata(idpEntityId);
        logoutResponse.validate(null, ctx.getSpMetadata().getSingleLogoutServiceHTTPPostResponseLocation(), metadata.getPublicKeys());
        ctx.getSessionHandler().logOut(session);
        Audit.log(Operation.LOGOUT, null);
        String homeUrl = ctx.getConfiguration().getString("oiosaml-sp.uri.home");
        if (log.isDebugEnabled()) {
            log.debug("sendRedirect to..:" + homeUrl);
        }
        if (homeUrl == null) {
            homeUrl = request.getContextPath();
        }
        ctx.getResponse().sendRedirect(homeUrl);
    }
}

