/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.AuthenticationHandler;
import dk.itst.oiosaml.sp.LogoutAuthenticationHandler;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.OIOLogoutRequest;
import dk.itst.oiosaml.sp.model.OIOLogoutResponse;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import dk.itst.oiosaml.sp.service.util.Utils;
import dk.itst.oiosaml.sp.util.LogoutRequestValidationException;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class LogoutServiceHTTPRedirectHandler
implements SAMLHandler {
    private static final long serialVersionUID = -6035256219067030678L;
    public static final String VERSION = "$Id: LogoutServiceHTTPRedirectHandler.java 2890 2008-05-16 16:18:56Z jre $";
    private static final Logger log = LoggerFactory.getLogger(LogoutServiceHTTPRedirectHandler.class);

    @Override
    public void handleGet(RequestContext ctx) throws ServletException, IOException {
        HttpServletRequest request = ctx.getRequest();
        HttpSession session = ctx.getSession();
        String samlRequest = request.getParameter("SAMLRequest");
        String relayState = request.getParameter("RelayState");
        String sigAlg = request.getParameter("SigAlg");
        String sig = request.getParameter("Signature");
        if (log.isDebugEnabled()) {
            log.debug("samlRequest...:" + samlRequest);
            log.debug("relayState....:" + relayState);
            log.debug("sigAlg........:" + sigAlg);
            log.debug("signature.....:" + sig);
        }
        OIOLogoutRequest logoutRequest = OIOLogoutRequest.fromRedirectRequest(request);
        if (log.isDebugEnabled()) {
            log.debug("Got InboundSAMLMessage..:" + logoutRequest.toXML());
        }
        Audit.log(Operation.LOGOUTREQUEST, false, logoutRequest.getID(), logoutRequest.toXML());
        String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
        String consent = null;
        OIOAssertion assertion = ctx.getSessionHandler().getAssertion(session.getId());
        String idpEntityId = null;
        if (assertion != null) {
            idpEntityId = assertion.getIssuer();
        }
        if (idpEntityId == null) {
            log.warn("LogoutRequest received but user is not logged in");
            idpEntityId = logoutRequest.getIssuer();
        }
        if (idpEntityId == null) {
            throw new RuntimeException("User is not logged in, and there is no Issuer in the LogoutRequest. Unable to continue.");
        }
        IdpMetadata.Metadata metadata = ctx.getIdpMetadata().getMetadata(idpEntityId);
        try {
            logoutRequest.validateRequest(sig, request.getQueryString(), metadata.getPublicKeys(), ctx.getSpMetadata().getSingleLogoutServiceHTTPRedirectLocation(), metadata.getEntityID());
            if (assertion != null) {
                log.info("Logging user out via SLO HTTP Redirect: " + assertion.getSubjectNameIDValue());
            } else {
                log.info("Logging user out via SLO HTTP Redirect without active session");
            }
            ctx.getSessionHandler().logOut(session);
            LogoutServiceHTTPRedirectHandler.invokeAuthenticationHandler(ctx);
        }
        catch (LogoutRequestValidationException e1) {
            consent = e1.getMessage();
            statusCode = "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed";
        }
        if (log.isDebugEnabled()) {
            log.debug("Logout status: " + statusCode + ", message: " + consent);
        }
        OIOLogoutResponse res = OIOLogoutResponse.fromRequest(logoutRequest, statusCode, consent, ctx.getSpMetadata().getEntityID(), metadata.getSingleLogoutServiceResponseLocation());
        String url = res.getRedirectURL(ctx.getCredential(), relayState);
        Audit.log(Operation.LOGOUTRESPONSE, true, res.getID(), res.toXML());
        if (log.isDebugEnabled()) {
            log.debug("sendRedirect to..:" + url);
        }
        ctx.getResponse().sendRedirect(url);
    }

    @Override
    public void handlePost(RequestContext ctx) throws ServletException, IOException {
        HttpServletRequest request = ctx.getRequest();
        HttpSession session = ctx.getSession();
        String samlRequest = request.getParameter("SAMLRequest");
        String relayState = request.getParameter("RelayState");
        String sigAlg = request.getParameter("SigAlg");
        String sig = request.getParameter("Signature");
        if (log.isDebugEnabled()) {
            log.debug("samlRequest...:" + samlRequest);
            log.debug("relayState....:" + relayState);
            log.debug("sigAlg........:" + sigAlg);
            log.debug("signature.....:" + sig);
        }
        OIOLogoutRequest logoutRequest = OIOLogoutRequest.fromPostRequest(request);
        if (log.isDebugEnabled()) {
            log.debug("Got InboundSAMLMessage..:" + logoutRequest.toXML());
        }
        Audit.log(Operation.LOGOUTREQUEST, false, logoutRequest.getID(), logoutRequest.toXML());
        String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
        String consent = null;
        OIOAssertion assertion = ctx.getSessionHandler().getAssertion(session.getId());
        String idpEntityId = null;
        if (assertion != null) {
            idpEntityId = assertion.getIssuer();
        }
        if (idpEntityId == null) {
            log.warn("LogoutRequest received but user is not logged in");
            idpEntityId = logoutRequest.getIssuer();
        }
        if (idpEntityId == null) {
            throw new RuntimeException("User is not logged in, and there is no Issuer in the LogoutRequest. Unable to continue.");
        }
        IdpMetadata.Metadata metadata = ctx.getIdpMetadata().getMetadata(idpEntityId);
        try {
            logoutRequest.validateRequest(sig, request.getQueryString(), metadata.getPublicKeys(), ctx.getSpMetadata().getSingleLogoutServiceHTTPPostLocation(), metadata.getEntityID());
            if (assertion != null) {
                log.info("Logging user out via SLO HTTP POST: " + assertion.getSubjectNameIDValue());
            } else {
                log.info("Logging user out via SLO HTTP POST without active session");
            }
            ctx.getSessionHandler().logOut(session);
            LogoutServiceHTTPRedirectHandler.invokeAuthenticationHandler(ctx);
        }
        catch (LogoutRequestValidationException e1) {
            consent = e1.getMessage();
            statusCode = "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed";
        }
        if (log.isDebugEnabled()) {
            log.debug("Logout status: " + statusCode + ", message: " + consent);
        }
        OIOLogoutResponse res = OIOLogoutResponse.fromRequest(logoutRequest, statusCode, consent, ctx.getSpMetadata().getEntityID(), metadata.getSingleLogoutServiceResponseLocation());
        String url = res.getRedirectURL(ctx.getCredential(), relayState);
        Audit.log(Operation.LOGOUTRESPONSE, true, res.getID(), res.toXML());
        if (log.isDebugEnabled()) {
            log.debug("sendRedirect to..:" + url);
        }
        ctx.getResponse().sendRedirect(url);
    }

    private static void invokeAuthenticationHandler(RequestContext ctx) {
        String handlerClass = ctx.getConfiguration().getString("oiosaml-sp.authenticationhandler", null);
        if (handlerClass != null) {
            log.debug("Authentication handler: " + handlerClass);
            AuthenticationHandler handler = (AuthenticationHandler)Utils.newInstance(ctx.getConfiguration(), "oiosaml-sp.authenticationhandler");
            if (handler instanceof LogoutAuthenticationHandler) {
                ((LogoutAuthenticationHandler)handler).userLoggedOut(ctx.getRequest(), ctx.getResponse());
            }
        } else {
            log.debug("No authentication handler configured");
        }
    }
}

