/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.model.OIOAssertion;
import dk.itst.oiosaml.sp.model.OIOLogoutRequest;
import dk.itst.oiosaml.sp.model.OIOLogoutResponse;
import dk.itst.oiosaml.sp.service.RequestContext;
import dk.itst.oiosaml.sp.service.SAMLHandler;
import dk.itst.oiosaml.sp.util.LogoutRequestValidationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.ws.soap.soap11.Body;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.security.credential.Credential;

public class LogoutServiceSOAPHandler
implements SAMLHandler {
    private static final Logger log = LoggerFactory.getLogger(LogoutServiceSOAPHandler.class);

    private static OIOLogoutRequest extractRequest(HttpServletRequest request) throws IOException {
        Envelope envelope;
        Body body;
        ServletInputStream is = request.getInputStream();
        String xml = IOUtils.toString((InputStream)is, (String)"UTF-8");
        XMLObject xmlObject = SAMLUtil.unmarshallElementFromString(xml);
        if (log.isDebugEnabled()) {
            log.debug("Request..:" + xml);
        }
        if (xmlObject != null && xmlObject instanceof Envelope && (xmlObject = (XMLObject)(body = (envelope = (Envelope)xmlObject).getBody()).getUnknownXMLObjects().get(0)) != null && xmlObject instanceof LogoutRequest) {
            LogoutRequest logoutRequest = (LogoutRequest)xmlObject;
            return new OIOLogoutRequest(logoutRequest);
        }
        throw new RuntimeException("SOAP request did not contain a LogoutRequest on the body");
    }

    @Override
    public void handlePost(RequestContext ctx) throws ServletException, IOException {
        String statusCode = "urn:oasis:names:tc:SAML:2.0:status:Success";
        String consent = null;
        OIOLogoutRequest logoutRequest = LogoutServiceSOAPHandler.extractRequest(ctx.getRequest());
        Audit.log(Operation.LOGOUT_SOAP, false, logoutRequest.getID(), logoutRequest.toXML());
        try {
            String sessionIndex = logoutRequest.getSessionIndex();
            String sessionId = ctx.getSessionHandler().getRelatedSessionId(sessionIndex);
            OIOAssertion assertion = ctx.getSessionHandler().getAssertion(sessionId);
            String idpEntityId = null;
            if (assertion != null) {
                idpEntityId = assertion.getIssuer();
            }
            if (idpEntityId == null) {
                log.warn("LogoutRequest received over SOAP for unknown user");
                statusCode = "urn:oasis:names:tc:SAML:2.0:status:NoSupportedIDP";
            } else {
                try {
                    IdpMetadata.Metadata metadata = ctx.getIdpMetadata().getMetadata(idpEntityId);
                    logoutRequest.validateRequest(null, null, metadata.getPublicKeys(), ctx.getSpMetadata().getSingleLogoutServiceSOAPLocation(), metadata.getEntityID());
                    ctx.getSessionHandler().logOut(sessionId);
                    Audit.log(Operation.LOGOUT, assertion.getSubjectNameIDValue());
                }
                catch (LogoutRequestValidationException e) {
                    consent = e.getMessage();
                    statusCode = "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed";
                }
            }
        }
        catch (Throwable t) {
            statusCode = "urn:oasis:names:tc:SAML:2.0:status:AuthnFailed";
            consent = t instanceof WrappedException ? t.getCause().getMessage() : t.getMessage();
            Audit.logError(Operation.LOGOUT_SOAP, false, logoutRequest.getID(), t);
        }
        if (log.isDebugEnabled()) {
            log.debug("Logout status: " + statusCode + ", message: " + consent);
        }
        OIOLogoutResponse logoutResponse = OIOLogoutResponse.fromRequest(logoutRequest, statusCode, consent, ctx.getSpMetadata().getEntityID(), null);
        LogoutServiceSOAPHandler.returnResponse(ctx.getResponse(), logoutResponse, ctx.getCredential());
        Audit.log(Operation.LOGOUT_SOAP, true, logoutRequest.getID(), logoutResponse.toXML());
    }

    @Override
    public void handleGet(RequestContext ctx) throws IOException {
        String wsdl = ctx.getRequest().getParameter("wsdl");
        HttpServletResponse response = ctx.getResponse();
        if (wsdl != null) {
            try {
                if (log.isDebugEnabled()) {
                    log.debug("Returning wsdl...");
                }
                PrintWriter out = response.getWriter();
                response.setContentType("text/xml");
                response.setCharacterEncoding("UTF-8");
                InputStream in = LogoutServiceSOAPHandler.class.getResourceAsStream("/SAML2LogoutService.wsdl");
                IOUtils.copy((InputStream)in, (Writer)out);
                in.close();
                out.flush();
                return;
            }
            catch (IOException e) {
                throw new WrappedException(Layer.CLIENT, (Throwable)e);
            }
        }
        response.sendError(412, "No argument wsdl on get request. Use POST for SOAP requests.");
    }

    private static void returnResponse(HttpServletResponse response, OIOLogoutResponse logoutResponse, Credential credential) {
        byte[] b;
        logoutResponse.sign(credential);
        String envelope = logoutResponse.toSoapEnvelope();
        if (log.isDebugEnabled()) {
            log.debug("Response..: " + envelope);
        }
        try {
            b = envelope.getBytes("UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        response.setContentLength(b.length);
        response.setCharacterEncoding("UTF-8");
        response.setContentType("text/xml");
        response.setStatus(200);
        try {
            response.getOutputStream().write(b);
        }
        catch (IOException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
    }
}

