/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service;

import dk.itst.oiosaml.sp.OIOPrincipal;
import dk.itst.oiosaml.sp.UserAssertion;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class SAMLHttpServletRequest
extends HttpServletRequestWrapper {
    private final UserAssertion assertion;
    private final String hostname;
    private String relayState;

    public SAMLHttpServletRequest(HttpServletRequest request, UserAssertion assertion, String hostname) {
        super(request);
        this.assertion = assertion;
        this.hostname = hostname;
    }

    public SAMLHttpServletRequest(HttpServletRequest servletRequest, String hostname, String relayState) {
        this(servletRequest, (UserAssertion)null, hostname);
        this.relayState = relayState;
    }

    public String getRemoteUser() {
        if (this.assertion != null) {
            return this.assertion.getSubject();
        }
        return super.getRemoteUser();
    }

    public Principal getUserPrincipal() {
        if (this.assertion != null) {
            return new OIOPrincipal(this.assertion);
        }
        return super.getUserPrincipal();
    }

    public StringBuffer getRequestURL() {
        String url = super.getRequestURL().toString();
        String mod = this.hostname + url.substring(url.indexOf(47, 8));
        return new StringBuffer(mod);
    }

    public String getParameter(String name) {
        if ("RelayState".equals(name) && this.relayState != null) {
            return this.relayState;
        }
        return super.getParameter(name);
    }

    public String getQueryString() {
        if (this.relayState == null) {
            return super.getQueryString();
        }
        String q = super.getQueryString();
        if (q == null) {
            q = "";
        }
        return q + "&" + "RelayState" + "=" + this.relayState;
    }
}

