/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.session;

import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.service.session.SessionHandler;
import java.util.Timer;
import java.util.TimerTask;

public class SessionCleaner {
    private static final Logger log = LoggerFactory.getLogger(SessionCleaner.class);
    private static Timer cleanupTimer = null;

    public static void startCleaner(final SessionHandler handler, int maxInactiveIntervalSeconds, int delay) {
        log.info("Starting session cleaner");
        if (cleanupTimer != null) {
            cleanupTimer.cancel();
        }
        cleanupTimer = new Timer("Session Cleanup");
        final long sessionCleanupDelay = (long)maxInactiveIntervalSeconds * 1000L;
        final long requestIdsCleanupDelay = (long)delay * 1000L;
        cleanupTimer.schedule(new TimerTask(){

            @Override
            public void run() {
                log.debug("Cleaning sessions older than " + sessionCleanupDelay + " and request ids older than " + requestIdsCleanupDelay);
                handler.cleanup(requestIdsCleanupDelay, sessionCleanupDelay);
            }
        }, sessionCleanupDelay, sessionCleanupDelay);
    }

    public static void stopCleaner() {
        if (cleanupTimer != null) {
            cleanupTimer.cancel();
            cleanupTimer = null;
        }
    }
}

