/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.session.jdbc;

import dk.itst.oiosaml.sp.service.session.SessionHandler;
import dk.itst.oiosaml.sp.service.session.SessionHandlerFactory;
import dk.itst.oiosaml.sp.service.session.jdbc.JdbcSessionHandler;
import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.util.logging.Logger;
import javax.sql.DataSource;
import org.apache.commons.configuration.Configuration;

public class JdbcFactory
implements SessionHandlerFactory {
    private String url;
    private String username;
    private String password;
    private String driver;

    @Override
    public void close() {
    }

    @Override
    public void configure(Configuration config) {
        this.url = config.getString("oiosaml-sp.sessionhandler.jdbc.url");
        this.username = config.getString("oiosaml-sp.sessionhandler.jdbc.username");
        this.password = config.getString("oiosaml-sp.sessionhandler.jdbc.password");
        this.driver = config.getString("oiosaml-sp.sessionhandler.jdbc.driver");
        try {
            Class.forName(this.driver);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Unable to load driver " + this.driver, e);
        }
    }

    @Override
    public SessionHandler getHandler() {
        return new JdbcSessionHandler(new DS());
    }

    private class DS
    implements DataSource {
        private DS() {
        }

        @Override
        public Connection getConnection() throws SQLException {
            return DriverManager.getConnection(JdbcFactory.this.url, JdbcFactory.this.username, JdbcFactory.this.password);
        }

        @Override
        public Connection getConnection(String usernm, String passwd) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public Logger getParentLogger() throws SQLFeatureNotSupportedException {
            return null;
        }
    }
}

