/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.util;

import dk.itst.oiosaml.common.OIOSAMLConstants;
import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Audit;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.logging.Operation;
import dk.itst.oiosaml.sp.metadata.IdpMetadata;
import dk.itst.oiosaml.sp.model.OIOResponse;
import dk.itst.oiosaml.sp.service.util.SOAPClient;
import dk.itst.oiosaml.sp.service.util.Utils;
import dk.itst.oiosaml.sp.util.BRSArtifact;
import java.io.IOException;
import javax.servlet.http.HttpServletRequest;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.opensaml.common.binding.BindingException;
import org.opensaml.saml2.core.ArtifactResolve;
import org.opensaml.saml2.core.ArtifactResponse;
import org.opensaml.saml2.core.Response;
import org.opensaml.ws.soap.soap11.Envelope;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.XMLHelper;
import org.opensaml.xml.validation.ValidationException;
import org.w3c.dom.Node;

public class ArtifactExtractor {
    private static final Logger log = LoggerFactory.getLogger(ArtifactExtractor.class);
    private final String spEntityID;
    private String resolveUsername;
    private String resolvePassword;
    private final IdpMetadata idpMetadata;
    private final SOAPClient client;
    private final boolean ignoreCertPath;

    public ArtifactExtractor(IdpMetadata idpMetadata, String spEntityID, SOAPClient client, String resolveUsername, String resolvePassword, boolean ignoreCertPath) {
        this.idpMetadata = idpMetadata;
        this.spEntityID = spEntityID;
        this.client = client;
        this.resolveUsername = resolveUsername;
        this.resolvePassword = resolvePassword;
        this.ignoreCertPath = ignoreCertPath;
    }

    public OIOResponse extract(HttpServletRequest request) throws IOException {
        BRSArtifact artifact;
        String samlArt = request.getParameter("SAMLart");
        if (log.isDebugEnabled()) {
            log.debug("Got SAMLart..:" + samlArt);
        }
        if (samlArt == null) {
            throw new IllegalArgumentException(" Parameter 'SAMLart' is null...");
        }
        int endpointIndex = 0;
        try {
            artifact = new BRSArtifact(samlArt, this.idpMetadata.getEntityIDs().toArray(new String[0]));
            endpointIndex = artifact.getEndpointIndex();
            if (log.isDebugEnabled()) {
                log.debug("Got endpointIndex..:" + endpointIndex);
            }
        }
        catch (BindingException e) {
            throw new WrappedException(Layer.BUSINESS, (Throwable)e);
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException(samlArt, e);
        }
        String artifactResolutionServiceLocation = this.idpMetadata.getMetadata(artifact.getEntityId()).getArtifactResolutionServiceLocation("urn:oasis:names:tc:SAML:2.0:bindings:SOAP");
        String id = Utils.generateUUID();
        ArtifactResolve artifactResolve = this.buildArtifactResolve(samlArt, id, artifactResolutionServiceLocation);
        Audit.log(Operation.ARTIFACTRESOLVE, true, artifactResolve.getID(), XMLHelper.nodeToString((Node)SAMLUtil.marshallObject((XMLObject)artifactResolve)));
        Envelope env = this.client.wsCall((XMLObject)artifactResolve, artifactResolutionServiceLocation, this.resolveUsername, this.resolvePassword, this.ignoreCertPath);
        ArtifactResponse artifactResponse = (ArtifactResponse)env.getBody().getUnknownXMLObjects().get(0);
        try {
            artifactResponse.validate(false);
        }
        catch (ValidationException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        if (!id.equals(artifactResponse.getInResponseTo())) {
            RuntimeException e = new RuntimeException("Received different id than I sent: Expected " + id + ". Was " + artifactResponse.getInResponseTo());
            Audit.logError(Operation.ARTIFACTRESOLVE, false, artifactResolve.getID(), (Throwable)e);
            throw e;
        }
        String statusCode = artifactResponse.getStatus().getStatusCode().getValue();
        if (!"urn:oasis:names:tc:SAML:2.0:status:Success".equals(statusCode)) {
            RuntimeException e = new RuntimeException("Got ArtifactResponse:StatusCode " + statusCode + " should be " + "urn:oasis:names:tc:SAML:2.0:status:Success");
            Audit.logError(Operation.ARTIFACTRESOLVE, false, artifactResolve.getID(), (Throwable)e);
            throw e;
        }
        OIOResponse response = new OIOResponse((Response)artifactResponse.getMessage());
        Audit.log(Operation.ARTIFACTRESOLVE, false, artifactResolve.getID(), response.toXML());
        return response;
    }

    private ArtifactResolve buildArtifactResolve(String artifactValue, String id, String artifactResolutionLocation) {
        if (log.isDebugEnabled()) {
            log.debug("buildArtifactResolve...");
        }
        ArtifactResolve artifactResolve = SAMLUtil.buildXMLObject(ArtifactResolve.class);
        artifactResolve.addNamespace(OIOSAMLConstants.SAML20_NAMESPACE);
        artifactResolve.setIssuer(SAMLUtil.createIssuer(this.spEntityID));
        artifactResolve.setID(id);
        artifactResolve.setIssueInstant(new DateTime(DateTimeZone.UTC));
        artifactResolve.setArtifact(SAMLUtil.createArtifact(artifactValue));
        artifactResolve.setDestination(artifactResolutionLocation);
        try {
            artifactResolve.validate(true);
        }
        catch (ValidationException e) {
            throw new WrappedException(Layer.CLIENT, (Throwable)e);
        }
        return artifactResolve;
    }
}

