/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.service.util;

import dk.itst.oiosaml.common.SAMLUtil;
import dk.itst.oiosaml.error.Layer;
import dk.itst.oiosaml.error.WrappedException;
import dk.itst.oiosaml.logging.Logger;
import dk.itst.oiosaml.logging.LoggerFactory;
import dk.itst.oiosaml.sp.model.OIOResponse;
import java.io.UnsupportedEncodingException;
import javax.servlet.http.HttpServletRequest;
import org.opensaml.saml2.core.Response;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.util.Base64;

public class PostResponseExtractor {
    private static final Logger log = LoggerFactory.getLogger(PostResponseExtractor.class);

    public OIOResponse extract(HttpServletRequest request) {
        String samlResponse = request.getParameter("SAMLResponse");
        if (samlResponse == null) {
            throw new IllegalStateException("SAMLResponse parameter cannot be null");
        }
        if (log.isDebugEnabled()) {
            log.debug("SAMLResponse: " + samlResponse);
        }
        try {
            String xml = new String(Base64.decode((String)samlResponse), "UTF-8");
            XMLObject obj = SAMLUtil.unmarshallElementFromString(xml);
            if (!(obj instanceof Response)) {
                throw new IllegalArgumentException("SAMLResponse must be of type Response. Was " + obj);
            }
            return new OIOResponse((Response)obj);
        }
        catch (UnsupportedEncodingException e) {
            throw new WrappedException(Layer.BUSINESS, (Throwable)e);
        }
    }
}

