/*
 * Decompiled with CFR 0.152.
 */
package dk.itst.oiosaml.sp.util;

import dk.itst.oiosaml.common.OIOSAMLConstants;
import dk.itst.oiosaml.common.SAMLUtil;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.opensaml.saml2.core.Attribute;
import org.opensaml.saml2.core.impl.AttributeBuilder;
import org.opensaml.xml.Namespace;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.schema.XSAny;
import org.opensaml.xml.schema.XSString;
import org.opensaml.xml.schema.impl.XSAnyBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Node;

public class AttributeUtil
implements OIOSAMLConstants {
    public static final String VERSION = "$Id: AttributeUtil.java 2950 2008-05-28 08:22:34Z jre $";
    protected static BasicParserPool parser = new BasicParserPool();
    public static final QName XSI_TYPE_ATTRIBUTE_NAME = new QName("http://www.w3.org/2001/XMLSchema-instance", "type", "xsi");
    public static final String XS_STRING = "xs:string";

    public static Attribute createAttribute(String name, String friendlyName, String nameFormat) {
        Attribute attribute = new AttributeBuilder().buildObject();
        attribute.setName(name);
        attribute.setFriendlyName(friendlyName);
        attribute.setNameFormat(nameFormat);
        return attribute;
    }

    private static XSAny createAttributeValue() {
        XSAnyBuilder builder = new XSAnyBuilder();
        XSAny ep = builder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue", "saml2");
        return ep;
    }

    public static XSAny createAttributeValue(String value, String type) {
        XSAny ep = AttributeUtil.createAttributeValue();
        ep.setTextContent(String.valueOf(value));
        ep.getUnknownAttributes().put(XSI_TYPE_ATTRIBUTE_NAME, type);
        ep.addNamespace(new Namespace("http://www.w3.org/2001/XMLSchema-instance", "xsi"));
        return ep;
    }

    public static XSAny createAttributeValue(String value) {
        return AttributeUtil.createAttributeValue(value, XS_STRING);
    }

    public static Attribute createSurname(String value) {
        Attribute attribute = AttributeUtil.createAttribute("urn:oid:2.5.4.4", "surName", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createCommonName(String value) {
        Attribute attribute = AttributeUtil.createAttribute("urn:oid:2.5.4.3", "CommonName", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createUid(String value) {
        Attribute attribute = AttributeUtil.createAttribute("urn:oid:0.9.2342.19200300.100.1.1", "uid", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createMail(String value) {
        Attribute attribute = AttributeUtil.createAttribute("urn:oid:0.9.2342.19200300.100.1.3", "mail", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createCVRNumberIdentifier(String value) {
        Attribute attribute = AttributeUtil.createAttribute("dk:gov:saml:attribute:CvrNumberIdentifier", "CVRnumberIdentifier", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createSerialNumber(String value) {
        Attribute attribute = AttributeUtil.createAttribute("urn:oid:2.5.4.5", "serialNumber", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createPidNumberIdentifier(String value) {
        Attribute attribute = AttributeUtil.createAttribute("dk:gov:saml:attribute:PidNumberIdentifier", "PidNumberIdentifier", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createRidNumberIdentifier(String value) {
        Attribute attribute = AttributeUtil.createAttribute("dk:gov:saml:attribute:RidNumberIdentifier", "RidNumberIdentifier", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createUserCertificate(String value) {
        Attribute attribute = AttributeUtil.createAttribute("urn:oid:1.3.6.1.4.1.1466.115.121.1.8", "userCertificate", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != null) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(value));
        }
        return attribute;
    }

    public static Attribute createAssuranceLevel(int value) {
        Attribute attribute = AttributeUtil.createAttribute("dk:gov:saml:attribute:AssuranceLevel", "AssuranceLevel", "urn:oasis:names:tc:SAML:2.0:attrname-format:basic");
        if (value != 0) {
            attribute.getAttributeValues().add(AttributeUtil.createAttributeValue(String.valueOf(value)));
        }
        return attribute;
    }

    public static String extractAttributeValueValue(Attribute attribute) {
        for (int i = 0; i < attribute.getAttributeValues().size(); ++i) {
            if (attribute.getAttributeValues().get(i) instanceof XSString) {
                XSString str = (XSString)attribute.getAttributeValues().get(i);
                if (!"AttributeValue".equals(str.getElementQName().getLocalPart()) || !"urn:oasis:names:tc:SAML:2.0:assertion".equals(str.getElementQName().getNamespaceURI())) continue;
                return str.getValue();
            }
            XSAny ep = (XSAny)attribute.getAttributeValues().get(i);
            if (!"AttributeValue".equals(ep.getElementQName().getLocalPart()) || !"urn:oasis:names:tc:SAML:2.0:assertion".equals(ep.getElementQName().getNamespaceURI())) continue;
            if (ep.getUnknownXMLObjects().size() > 0) {
                StringBuilder res = new StringBuilder();
                for (XMLObject obj : ep.getUnknownXMLObjects()) {
                    res.append(XMLHelper.nodeToString((Node)SAMLUtil.marshallObject(obj)));
                }
                return res.toString();
            }
            return ep.getTextContent();
        }
        return null;
    }

    public static List<String> extractAttributeValueValues(Attribute attribute) {
        ArrayList<String> values = new ArrayList<String>();
        for (int i = 0; i < attribute.getAttributeValues().size(); ++i) {
            if (attribute.getAttributeValues().get(i) instanceof XSString) {
                XSString str = (XSString)attribute.getAttributeValues().get(i);
                if (!"AttributeValue".equals(str.getElementQName().getLocalPart()) || !"urn:oasis:names:tc:SAML:2.0:assertion".equals(str.getElementQName().getNamespaceURI())) continue;
                values.add(str.getValue());
                continue;
            }
            XSAny ep = (XSAny)attribute.getAttributeValues().get(i);
            if (!"AttributeValue".equals(ep.getElementQName().getLocalPart()) || !"urn:oasis:names:tc:SAML:2.0:assertion".equals(ep.getElementQName().getNamespaceURI())) continue;
            if (ep.getUnknownXMLObjects().size() > 0) {
                StringBuilder res = new StringBuilder();
                for (XMLObject obj : ep.getUnknownXMLObjects()) {
                    res.append(XMLHelper.nodeToString((Node)SAMLUtil.marshallObject(obj)));
                }
                values.add(res.toString());
            }
            values.add(ep.getTextContent());
        }
        return values;
    }
}

