/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz;

import com.pholser.junit.quickcheck.Property;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import com.pholser.junit.quickcheck.internal.generator.ServiceLoaderGeneratorSource;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import com.pholser.junit.quickcheck.runner.JUnitQuickcheck;
import edu.berkeley.cs.jqf.fuzz.Fuzz;
import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.junit.GuidedFuzzing;
import edu.berkeley.cs.jqf.fuzz.junit.quickcheck.FuzzStatement;
import edu.berkeley.cs.jqf.fuzz.random.NoGuidance;
import edu.berkeley.cs.jqf.fuzz.repro.ReproGuidance;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Random;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

public class JQF
extends JUnitQuickcheck {
    protected final GeneratorRepository generatorRepository;

    public JQF(Class<?> clazz) throws InitializationError {
        super(clazz);
        SourceOfRandomness randomness = new SourceOfRandomness(new Random(42L));
        this.generatorRepository = new GeneratorRepository(randomness).register((Iterable)new ServiceLoaderGeneratorSource());
    }

    protected List<FrameworkMethod> computeTestMethods() {
        List methods = super.computeTestMethods();
        methods.addAll(this.getTestClass().getAnnotatedMethods(Fuzz.class));
        return methods;
    }

    protected void validateTestMethods(List<Throwable> errors) {
        super.validateTestMethods(errors);
        this.validateFuzzMethods(errors);
    }

    private void validateFuzzMethods(List<Throwable> errors) {
        for (FrameworkMethod method : this.getTestClass().getAnnotatedMethods(Fuzz.class)) {
            method.validatePublicVoid(false, errors);
            if (method.getAnnotation(Property.class) == null) continue;
            errors.add(new Exception("Method " + method.getName() + " cannot have both @Property and @Fuzz annotations"));
        }
    }

    public Statement methodBlock(FrameworkMethod method) {
        if (method.getAnnotation(Fuzz.class) == null) {
            return super.methodBlock(method);
        }
        Guidance guidance = GuidedFuzzing.getCurrentGuidance();
        if (guidance == null) {
            String repro = ((Fuzz)method.getAnnotation(Fuzz.class)).repro();
            if (repro.isEmpty()) {
                long maxTrials = Long.getLong("jqf.quickcheck.trials", GuidedFuzzing.DEFAULT_MAX_TRIALS);
                guidance = new NoGuidance(maxTrials, System.err);
            } else {
                String reproPath;
                if (repro.matches("\\$\\{[a-zA-Z.\\d_$]*\\}")) {
                    String key = repro.substring(2, repro.length() - 1);
                    String val = System.getProperty(key);
                    if (val == null) {
                        throw new IllegalArgumentException(String.format("Test method has @Fuzz annotation with repro=%s, but such a system property is not set. Use `-D%s=<path>` when running.", repro, key));
                    }
                    reproPath = val;
                } else {
                    reproPath = repro;
                }
                File inputFile = new File(reproPath);
                try {
                    guidance = new ReproGuidance(inputFile, null);
                }
                catch (IOException e) {
                    throw new GuidanceException(String.format("Could not open repro file: %s", inputFile.getAbsolutePath()), e);
                }
            }
        }
        return new FuzzStatement(method, this.getTestClass(), this.generatorRepository, guidance);
    }
}

