/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.afl;

import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.guidance.Result;
import edu.berkeley.cs.jqf.fuzz.guidance.TimeoutException;
import edu.berkeley.cs.jqf.fuzz.util.Hashing;
import edu.berkeley.cs.jqf.instrument.tracing.events.BranchEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.CallEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import java.util.Date;
import java.util.function.Consumer;

public class AFLGuidance
implements Guidance {
    protected File inputFile;
    protected final InputStream proxyInput;
    protected final OutputStream proxyOutput;
    protected static final int COVERAGE_MAP_SIZE = 65536;
    protected byte[] traceBits = new byte[65536];
    protected boolean everything_ok = true;
    protected ByteBuffer feedback;
    private InputStream inputFileStream;
    private long singleRunTimeoutMillis;
    private Date runStart;
    private long branchCount;
    private volatile boolean timeoutHasOccurred;
    private static final int FEEDBACK_BUFFER_SIZE = 131072;
    private static final byte[] FEEDBACK_ZEROS = new byte[131072];

    public AFLGuidance(File inputFile, File inPipe, File outPipe) throws IOException {
        this.inputFile = inputFile;
        this.proxyInput = new BufferedInputStream(new FileInputStream(inPipe));
        this.proxyOutput = new BufferedOutputStream(new FileOutputStream(outPipe));
        this.feedback = ByteBuffer.allocate(131072);
        this.feedback.order(ByteOrder.LITTLE_ENDIAN);
        String timeout = System.getProperty("jqf.afl.TIMEOUT");
        if (timeout != null && !timeout.isEmpty()) {
            try {
                this.singleRunTimeoutMillis = Long.parseLong(timeout);
            }
            catch (NumberFormatException e1) {
                throw new IllegalArgumentException("Invalid timeout duration: " + timeout);
            }
        }
    }

    public AFLGuidance(String inputFileName, String inPipeName, String outPipeName) throws IOException {
        this(new File(inputFileName), new File(inPipeName), new File(outPipeName));
    }

    public void finalize() {
        if (this.proxyInput != null) {
            try {
                this.proxyInput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.proxyOutput != null) {
            try {
                this.proxyOutput.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    @Override
    public InputStream getInput() throws IllegalStateException, GuidanceException {
        if (!this.everything_ok) {
            throw new IllegalStateException("Fuzzing should have been stopped.");
        }
        try {
            this.inputFileStream = new BufferedInputStream(new FileInputStream(this.inputFile));
            this.runStart = new Date();
            this.branchCount = 0L;
            this.timeoutHasOccurred = false;
            return this.inputFileStream;
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
    }

    @Override
    public boolean hasInput() {
        if (this.everything_ok) {
            byte[] signal = new byte[4];
            try {
                int received = this.proxyInput.read(signal, 0, 4);
                if (received != 4) {
                    throw new IOException("Could not read `ready` from AFL");
                }
                Arrays.fill(this.traceBits, (byte)0);
            }
            catch (IOException e) {
                this.everything_ok = false;
            }
        }
        return this.everything_ok;
    }

    @Override
    public void handleResult(Result result, Throwable error) {
        int status;
        this.runStart = null;
        if (this.timeoutHasOccurred) {
            result = Result.TIMEOUT;
        }
        try {
            if (this.inputFileStream != null) {
                this.inputFileStream.close();
            }
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
        this.clearFeedbackBuffer();
        this.traceBits[0] = this.traceBits[0] == 0 ? (byte)1 : this.traceBits[0];
        switch (result) {
            case SUCCESS: {
                status = 0;
                break;
            }
            case FAILURE: {
                status = 6;
                break;
            }
            case INVALID: {
                status = 256;
                break;
            }
            case TIMEOUT: {
                status = 9;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid result: " + result);
            }
        }
        this.feedback.putInt(status);
        for (int i = 0; i < 65536; ++i) {
            this.feedback.put(this.traceBits[i]);
        }
        try {
            this.proxyOutput.write(this.feedback.array(), 0, this.feedback.position());
            this.proxyOutput.flush();
        }
        catch (IOException e) {
            this.everything_ok = false;
        }
    }

    @Override
    public Consumer<TraceEvent> generateCallBack(Thread thread) {
        return this::handleEvent;
    }

    protected void handleEvent(TraceEvent e) {
        if (e instanceof BranchEvent) {
            BranchEvent b = (BranchEvent)e;
            int edgeId = 1 + Hashing.hash1(b.getIid(), b.getArm(), 65535);
            this.incrementTraceBits(edgeId);
            this.checkForTimeouts();
        } else if (e instanceof CallEvent) {
            int edgeId = 1 + Hashing.hash(e.getIid(), 65535);
            this.incrementTraceBits(edgeId);
        }
    }

    protected void incrementTraceBits(int index) {
        int n = index;
        this.traceBits[n] = (byte)(this.traceBits[n] + 1);
    }

    protected void clearFeedbackBuffer() {
        ((Buffer)this.feedback).rewind();
        this.feedback.put(FEEDBACK_ZEROS);
        ((Buffer)this.feedback).rewind();
    }

    protected void checkForTimeouts() throws TimeoutException {
        long elapsed;
        if (this.singleRunTimeoutMillis > 0L && this.runStart != null && ++this.branchCount % 10000L == 0L && (elapsed = new Date().getTime() - this.runStart.getTime()) > this.singleRunTimeoutMillis) {
            this.timeoutHasOccurred = true;
            throw new TimeoutException(elapsed, this.singleRunTimeoutMillis);
        }
    }
}

