/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.ei;

import edu.berkeley.cs.jqf.fuzz.ei.ExecutionIndex;
import edu.berkeley.cs.jqf.fuzz.util.Counter;
import edu.berkeley.cs.jqf.fuzz.util.NonZeroCachingCounter;
import edu.berkeley.cs.jqf.instrument.tracing.events.CallEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.ReturnEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEventVisitor;
import java.util.ArrayList;
import java.util.Arrays;

public class ExecutionIndexingState
implements TraceEventVisitor {
    private final int COUNTER_SIZE = 6151;
    private final int MAX_SUPPORTED_DEPTH = 1024;
    private int depth = 0;
    private ArrayList<Counter> stackOfCounters = new ArrayList();
    private int[] rollingIndex = new int[2048];

    public ExecutionIndexingState() {
        this.stackOfCounters.add(new NonZeroCachingCounter(6151));
    }

    public void pushCall(CallEvent e) {
        int count = this.stackOfCounters.get(this.depth).increment(e.getIid());
        this.rollingIndex[2 * this.depth] = e.getIid();
        this.rollingIndex[2 * this.depth + 1] = count;
        ++this.depth;
        if (this.depth >= 1024) {
            throw new StackOverflowError("Very deep stack; cannot compute execution index");
        }
        if (this.depth >= this.stackOfCounters.size()) {
            this.stackOfCounters.add(new NonZeroCachingCounter(6151));
        }
    }

    public void popReturn(ReturnEvent e) {
        this.stackOfCounters.get(this.depth).clear();
        --this.depth;
        assert (this.depth >= 0);
    }

    public ExecutionIndex getExecutionIndex(TraceEvent e) {
        int count = this.stackOfCounters.get(this.depth).increment(e.getIid());
        this.rollingIndex[2 * this.depth] = e.getIid();
        this.rollingIndex[2 * this.depth + 1] = count;
        int size = 2 * (this.depth + 1);
        int[] ei = Arrays.copyOf(this.rollingIndex, size);
        return new ExecutionIndex(ei);
    }

    public void visitCallEvent(CallEvent c) {
        this.pushCall(c);
    }

    public void visitReturnEvent(ReturnEvent r) {
        this.popReturn(r);
    }
}

