/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.ei;

import edu.berkeley.cs.jqf.fuzz.ei.ZestGuidance;
import edu.berkeley.cs.jqf.fuzz.junit.GuidedFuzzing;
import edu.berkeley.cs.jqf.instrument.InstrumentingClassLoader;
import java.io.File;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.Random;
import org.junit.runner.Result;
import picocli.CommandLine;

@CommandLine.Command(name="ZestCLI", mixinStandardHelpOptions=true, version={"1.3"})
public class ZestCLI
implements Runnable {
    @CommandLine.ArgGroup(exclusive=false, multiplicity="0..2")
    Dependent dependent;
    @CommandLine.Option(names={"-l", "--libfuzzer-compat-output"}, description={"Use libFuzzer compat output instead of AFL like stats screen (default: false)"})
    private boolean libFuzzerCompatOutput = false;
    @CommandLine.Option(names={"-i", "--input"}, description={"Input directory containing seed test cases (default: none)"})
    private File inputDirectory;
    @CommandLine.Option(names={"-o", "--output"}, description={"Output Directory containing results (default: fuzz_results)"})
    private File outputDirectory = new File("fuzz-results");
    @CommandLine.Option(names={"-d", "--duration"}, description={"Total fuzz duration (e.g. PT5s or 5s)"})
    private Duration duration;
    @CommandLine.Option(names={"-t", "--trials"}, description={"Total trial duration"})
    private Long trials;
    @CommandLine.Option(names={"-r", "--deterministic"}, description={"Deterministic fuzzing; generate the same inputs each run (default: false)"})
    private boolean det = false;
    @CommandLine.Option(names={"-b", "--blind"}, description={"Blind fuzzing: do not use coverage feedback (default: false)"})
    private boolean blindFuzzing;
    @CommandLine.Parameters(index="0", paramLabel="PACKAGE", description={"package containing the fuzz target and all dependencies"})
    private String testPackageName;
    @CommandLine.Parameters(index="1", paramLabel="TEST_CLASS", description={"full class name where the fuzz function is located"})
    private String testClassName;
    @CommandLine.Parameters(index="2", paramLabel="TEST_METHOD", description={"fuzz function name"})
    private String testMethodName;

    private File[] readSeedFiles() {
        if (this.inputDirectory == null) {
            return new File[0];
        }
        ArrayList<File> seedFilesArray = new ArrayList<File>();
        File[] allFiles = this.inputDirectory.listFiles();
        if (allFiles == null) {
            return new File[0];
        }
        for (int i = 0; i < allFiles.length; ++i) {
            if (!allFiles[i].isFile()) continue;
            seedFilesArray.add(allFiles[i]);
        }
        File[] seedFiles = seedFilesArray.toArray(new File[seedFilesArray.size()]);
        return seedFiles;
    }

    @Override
    public void run() {
        File[] seedFiles = this.readSeedFiles();
        if (this.dependent != null) {
            if (this.dependent.exitOnCrash) {
                System.setProperty("jqf.ei.EXIT_ON_CRASH", "true");
            }
            if (this.dependent.exactCrashPath != null) {
                System.setProperty("jqf.ei.EXACT_CRASH_PATH", this.dependent.exactCrashPath);
            }
        }
        if (this.libFuzzerCompatOutput) {
            System.setProperty("jqf.ei.LIBFUZZER_COMPAT_OUTPUT", "true");
        }
        try {
            InstrumentingClassLoader loader = new InstrumentingClassLoader(this.testPackageName.split(File.pathSeparator), ZestCLI.class.getClassLoader());
            String title = this.testClassName + "#" + this.testMethodName;
            Random rnd = this.det ? new Random(0L) : new Random();
            ZestGuidance guidance = seedFiles.length > 0 ? new ZestGuidance(title, this.duration, this.trials, this.outputDirectory, seedFiles, rnd) : new ZestGuidance(title, this.duration, this.trials, this.outputDirectory, this.inputDirectory, rnd);
            guidance.setBlind(this.blindFuzzing);
            Result res = GuidedFuzzing.run(this.testClassName, this.testMethodName, (ClassLoader)loader, guidance, System.out);
            if (Boolean.getBoolean("jqf.logCoverage")) {
                System.out.println(String.format("Covered %d edges.", guidance.getTotalCoverage().getNonZeroCount()));
            }
            if (Boolean.getBoolean("jqf.ei.EXIT_ON_CRASH") && !res.wasSuccessful()) {
                System.exit(3);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }

    public static void main(String[] args) {
        int exitCode = new CommandLine((Object)new ZestCLI()).registerConverter(Duration.class, v -> {
            try {
                return Duration.parse(v);
            }
            catch (DateTimeParseException e) {
                return Duration.parse("PT" + v);
            }
        }).execute(args);
        System.exit(exitCode);
    }

    static class Dependent {
        @CommandLine.Option(names={"-e", "--exit-on-crash"}, description={"Exit fuzzer on first crash (default: false)"})
        boolean exitOnCrash = false;
        @CommandLine.Option(names={"--exact-crash-path"}, description={"exact path for the crash"})
        String exactCrashPath;

        Dependent() {
        }
    }
}

