/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.guidance;

import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.guidance.Result;
import edu.berkeley.cs.jqf.fuzz.junit.TrialRunner;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.TestClass;

public interface Guidance {
    public InputStream getInput() throws IllegalStateException, GuidanceException;

    public boolean hasInput();

    default public void observeGeneratedArgs(Object[] args) {
    }

    public void handleResult(Result var1, Throwable var2) throws GuidanceException;

    public Consumer<TraceEvent> generateCallBack(Thread var1);

    public static InputStream createInputStream(final Supplier<Integer> inputByteSource) {
        return new InputStream(){

            @Override
            public int read() throws IOException {
                int val = (Integer)inputByteSource.get();
                if (val < -1 || val > 255) {
                    throw new IOException("inputByteSource should return a byte or -1 on EOF");
                }
                return val;
            }
        };
    }

    default public void run(TestClass testClass, FrameworkMethod method, Object[] args) throws Throwable {
        new TrialRunner(testClass.getJavaClass(), method, args).run();
    }
}

