/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.junit.quickcheck;

import com.pholser.junit.quickcheck.internal.Ranges;
import com.pholser.junit.quickcheck.random.SourceOfRandomness;
import edu.berkeley.cs.jqf.fuzz.guidance.StreamBackedRandom;
import java.util.Random;

public class FastSourceOfRandomness
extends SourceOfRandomness {
    private StreamBackedRandom delegate;

    public FastSourceOfRandomness(StreamBackedRandom delegate) {
        super((Random)delegate);
        this.delegate = delegate;
    }

    public Random toJDKRandom() {
        return this.delegate;
    }

    public byte nextByte(byte min, byte max) {
        if (min == -128 && max == 127) {
            return this.delegate.nextByte();
        }
        if (min < -128 || max <= 127) {
            // empty if block
        }
        return this.fastChooseByteInRange(min, max);
    }

    public short nextShort(short min, short max) {
        if (min == Short.MIN_VALUE && max == Short.MAX_VALUE) {
            return this.delegate.nextShort();
        }
        return (short)this.fastChooseIntInRange(min, max);
    }

    public char nextChar(char min, char max) {
        Ranges.checkRange((Ranges.Type)Ranges.Type.CHARACTER, (Comparable)Character.valueOf(min), (Comparable)Character.valueOf(max));
        return (char)this.fastChooseIntInRange(min, max);
    }

    public int nextInt(int min, int max) {
        if (min == Integer.MIN_VALUE && max == Integer.MAX_VALUE) {
            return this.delegate.nextInt();
        }
        return this.fastChooseIntInRange(min, max);
    }

    public long nextLong(long min, long max) {
        int comparison = Ranges.checkRange((Ranges.Type)Ranges.Type.INTEGRAL, (Comparable)Long.valueOf(min), (Comparable)Long.valueOf(max));
        if (min == Long.MIN_VALUE && max == Long.MAX_VALUE) {
            return this.delegate.nextLong();
        }
        return comparison == 0 ? min : Ranges.choose((SourceOfRandomness)this, (long)min, (long)max);
    }

    private int fastChooseIntInRange(int min, int max) {
        int range = max - min;
        if (range > 0) {
            int random = this.delegate.nextInt() % range;
            if (random < 0) {
                random += range;
            }
            return min + random;
        }
        return (int)Ranges.choose((SourceOfRandomness)this, (long)min, (long)max);
    }

    private byte fastChooseByteInRange(byte min, byte max) {
        int range = max - min;
        if (range > 0 && range <= 127) {
            int random = this.delegate.nextByte() % range;
            if (random < 0) {
                random += range;
            }
            byte result = (byte)(min + random);
            assert (result >= min && result <= max);
            return result;
        }
        return (byte)this.fastChooseIntInRange(min, max);
    }
}

