/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.random;

import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.guidance.Result;
import edu.berkeley.cs.jqf.fuzz.util.Coverage;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import java.io.InputStream;
import java.io.PrintStream;
import java.util.Random;
import java.util.function.Consumer;

public class NoGuidance
implements Guidance {
    private boolean keepGoing = true;
    private long numTrials = 0L;
    private long numDiscards = 0L;
    private final long maxTrials;
    private final float maxDiscardRatio = 0.9f;
    private final PrintStream out;
    private Random random = new Random();
    private Coverage coverage;
    private static boolean KEEP_GOING_ON_ERROR = true;

    public NoGuidance(long maxTrials, PrintStream out) {
        if (maxTrials <= 0L) {
            throw new IllegalArgumentException("maxTrials must be greater than 0");
        }
        this.maxTrials = maxTrials;
        this.out = out;
    }

    @Override
    public InputStream getInput() {
        return Guidance.createInputStream(() -> this.random.nextInt(256));
    }

    @Override
    public boolean hasInput() {
        return this.keepGoing;
    }

    @Override
    public void handleResult(Result result, Throwable error) {
        ++this.numTrials;
        if (result == Result.FAILURE) {
            if (this.out != null) {
                error.printStackTrace(this.out);
            }
            this.keepGoing = KEEP_GOING_ON_ERROR;
        }
        if (result == Result.INVALID) {
            ++this.numDiscards;
        }
        if (this.numTrials >= this.maxTrials) {
            this.keepGoing = false;
        }
        if (this.numTrials > 10L && (float)this.numDiscards / (float)this.numTrials > 0.9f) {
            throw new GuidanceException("Assumption is too strong; too many inputs discarded");
        }
    }

    @Override
    public Consumer<TraceEvent> generateCallBack(Thread thread) {
        return this.getCoverage()::handleEvent;
    }

    public Coverage getCoverage() {
        if (this.coverage == null) {
            this.coverage = new Coverage();
        }
        return this.coverage;
    }
}

