/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.repro;

import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.junit.GuidedFuzzing;
import edu.berkeley.cs.jqf.fuzz.repro.ReproGuidance;
import java.io.File;

public class ReproDriver {
    public static void main(String[] args) {
        if (args.length < 3) {
            System.err.println("Usage: java " + ReproDriver.class + " TEST_CLASS TEST_METHOD TEST_INPUT_FILE...");
            System.exit(1);
        }
        String testClassName = args[0];
        String testMethodName = args[1];
        File[] testInputFiles = new File[args.length - 2];
        for (int i = 0; i < testInputFiles.length; ++i) {
            testInputFiles[i] = new File(args[i + 2]);
        }
        try {
            String traceDirName = System.getProperty("jqf.repro.traceDir");
            File traceDir = traceDirName != null ? new File(traceDirName) : null;
            ReproGuidance guidance = new ReproGuidance(testInputFiles, traceDir);
            GuidedFuzzing.run(testClassName, testMethodName, (Guidance)guidance, System.out);
            if (guidance.getBranchesCovered() != null) {
                Object cov = "";
                for (String s : guidance.getBranchesCovered()) {
                    cov = (String)cov + "# Covered: " + s + "\n";
                }
                String finalFooter = cov;
                System.out.println(finalFooter);
            }
            if (Boolean.getBoolean("jqf.logCoverage")) {
                System.out.println(String.format("Covered %d edges.", guidance.getCoverage().getNonZeroCount()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(2);
        }
    }
}

