/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.repro;

import edu.berkeley.cs.jqf.fuzz.guidance.Guidance;
import edu.berkeley.cs.jqf.fuzz.guidance.GuidanceException;
import edu.berkeley.cs.jqf.fuzz.guidance.Result;
import edu.berkeley.cs.jqf.fuzz.util.Coverage;
import edu.berkeley.cs.jqf.fuzz.util.IOUtils;
import edu.berkeley.cs.jqf.instrument.tracing.events.BranchEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.CallEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.jacoco.core.analysis.Analyzer;
import org.jacoco.core.analysis.CoverageBuilder;
import org.jacoco.core.analysis.ICoverageVisitor;
import org.jacoco.core.tools.ExecFileLoader;
import org.jacoco.report.IReportVisitor;
import org.jacoco.report.csv.CSVFormatter;

public class ReproGuidance
implements Guidance {
    private final File[] inputFiles;
    private final File traceDir;
    private int nextFileIdx = 0;
    private List<PrintStream> traceStreams = new ArrayList<PrintStream>();
    private InputStream inputStream;
    private Coverage coverage = new Coverage();
    private Set<String> branchesCoveredInCurrentRun;
    private Set<String> allBranchesCovered;
    private boolean ignoreInvalidCoverage;
    private boolean printArgs;
    private String dumpArgsDir;
    HashMap<Integer, String> branchDescCache = new HashMap();
    private boolean stopOnFailure = false;
    private boolean observedFailure = false;

    public ReproGuidance(File[] inputFiles, File traceDir) throws IOException {
        this.inputFiles = inputFiles;
        this.traceDir = traceDir;
        if (Boolean.getBoolean("jqf.repro.logUniqueBranches")) {
            this.allBranchesCovered = new HashSet<String>();
            this.branchesCoveredInCurrentRun = new HashSet<String>();
            this.ignoreInvalidCoverage = Boolean.getBoolean("jqf.repro.ignoreInvalidCoverage");
        }
        this.printArgs = Boolean.getBoolean("jqf.repro.printArgs");
        this.dumpArgsDir = System.getProperty("jqf.repro.dumpArgsDir");
        if (this.dumpArgsDir != null) {
            IOUtils.createDirectory(new File(this.dumpArgsDir));
        }
    }

    public ReproGuidance(File inputFile, File traceDir) throws IOException {
        this(IOUtils.resolveInputFileOrDirectory(inputFile), traceDir);
    }

    public void setStopOnFailure(boolean value) {
        this.stopOnFailure = value;
    }

    @Override
    public InputStream getInput() {
        try {
            File inputFile = this.inputFiles[this.nextFileIdx];
            this.inputStream = new BufferedInputStream(new FileInputStream(inputFile));
            if (this.allBranchesCovered != null) {
                this.branchesCoveredInCurrentRun.clear();
            }
            return this.inputStream;
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
    }

    @Override
    public boolean hasInput() {
        return this.nextFileIdx < this.inputFiles.length && (!this.stopOnFailure || !this.observedFailure);
    }

    @Override
    public void observeGeneratedArgs(Object[] args) {
        if (this.printArgs) {
            String inputFileName = this.getCurrentInputFile().getName();
            for (int i = 0; i < args.length; ++i) {
                System.out.printf("%s[%d]: %s\n", inputFileName, i, String.valueOf(args[i]));
            }
        }
        if (this.dumpArgsDir != null) {
            for (int i = 0; i < args.length; ++i) {
                String dumpFileName = String.format("%s.%d", this.getCurrentInputFile().getName(), i);
                File dumpFile = new File(this.dumpArgsDir, dumpFileName);
                Object arg = args[i];
                GuidanceException.wrap(() -> this.writeObjectToFile(dumpFile, arg));
            }
        }
    }

    private void writeObjectToFile(File file, Object obj) throws IOException {
        try (PrintWriter out = new PrintWriter(file);){
            out.print(obj);
        }
    }

    private File getCurrentInputFile() {
        return this.inputFiles[this.nextFileIdx];
    }

    @Override
    public void handleResult(Result result, Throwable error) {
        String jacocoAccumulateJar;
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
            }
        }
        catch (IOException e) {
            throw new GuidanceException(e);
        }
        File inputFile = this.getCurrentInputFile();
        if (result == Result.FAILURE) {
            this.observedFailure = true;
            System.out.printf("%s ::= %s (%s)\n", new Object[]{inputFile.getName(), result, error.getClass().getName()});
        } else {
            System.out.printf("%s ::= %s\n", new Object[]{inputFile.getName(), result});
        }
        if (!(this.allBranchesCovered == null || this.ignoreInvalidCoverage && result != Result.SUCCESS)) {
            assert (this.branchesCoveredInCurrentRun != null);
            this.allBranchesCovered.addAll(this.branchesCoveredInCurrentRun);
        }
        if (this.traceDir != null) {
            File resultsCsv = new File(this.traceDir, "results.csv");
            boolean append = this.nextFileIdx > 0;
            try (PrintStream out = new PrintStream(new FileOutputStream(resultsCsv, append));){
                String inputName = this.getCurrentInputFile().toString();
                String exception = result == Result.FAILURE ? error.getClass().getName() : "";
                out.printf("%s,%s,%s\n", new Object[]{inputName, result, exception});
            }
            catch (IOException e) {
                throw new GuidanceException(e);
            }
        }
        if ((jacocoAccumulateJar = System.getProperty("jqf.repro.jacocoAccumulateJar")) != null) {
            String dir = System.getProperty("jqf.repro.jacocoAccumulateDir", ".");
            this.jacocoCheckpoint(new File(jacocoAccumulateJar), new File(dir));
        }
        ++this.nextFileIdx;
    }

    @Override
    public Consumer<TraceEvent> generateCallBack(Thread thread) {
        if (this.branchesCoveredInCurrentRun != null) {
            return e -> {
                this.coverage.handleEvent((TraceEvent)e);
                if (e instanceof BranchEvent) {
                    BranchEvent b = (BranchEvent)e;
                    int hash = b.getIid() * 31 + b.getArm();
                    String str = this.branchDescCache.get(hash);
                    if (str == null) {
                        str = String.format("(%09d) %s#%s():%d [%d]", b.getIid(), b.getContainingClass(), b.getContainingMethodName(), b.getLineNumber(), b.getArm());
                        this.branchDescCache.put(hash, str);
                    }
                    this.branchesCoveredInCurrentRun.add(str);
                } else if (e instanceof CallEvent) {
                    CallEvent c = (CallEvent)e;
                    String str = this.branchDescCache.get(c.getIid());
                    if (str == null) {
                        str = String.format("(%09d) %s#%s():%d --> %s", c.getIid(), c.getContainingClass(), c.getContainingMethodName(), c.getLineNumber(), c.getInvokedMethodName());
                        this.branchDescCache.put(c.getIid(), str);
                    }
                    this.branchesCoveredInCurrentRun.add(str);
                }
            };
        }
        if (this.traceDir != null) {
            File traceFile = new File(this.traceDir, thread.getName() + ".log");
            try {
                PrintStream out = new PrintStream(traceFile);
                this.traceStreams.add(out);
                return e -> {
                    this.coverage.handleEvent((TraceEvent)e);
                    out.println(e);
                };
            }
            catch (FileNotFoundException e2) {
                System.err.println("Could not open trace file: " + traceFile.getAbsolutePath());
            }
        }
        return this.coverage::handleEvent;
    }

    public Coverage getCoverage() {
        return this.coverage;
    }

    public Set<String> getBranchesCovered() {
        return this.allBranchesCovered;
    }

    public void jacocoCheckpoint(File classFile, File csvDir) {
        int idx = this.nextFileIdx;
        csvDir.mkdirs();
        try {
            Class<?> RT = Class.forName("org.jacoco.agent.rt.RT");
            Method getAgent = RT.getMethod("getAgent", new Class[0]);
            Object agent = getAgent.invoke(null, new Object[0]);
            Method dump = agent.getClass().getMethod("getExecutionData", Boolean.TYPE);
            byte[] execData = (byte[])dump.invoke(agent, false);
            ExecFileLoader loader = new ExecFileLoader();
            loader.load((InputStream)new ByteArrayInputStream(execData));
            CoverageBuilder builder = new CoverageBuilder();
            Analyzer analyzer = new Analyzer(loader.getExecutionDataStore(), (ICoverageVisitor)builder);
            analyzer.analyzeAll(classFile);
            File csv = new File(csvDir, String.format("cov-%05d.csv", idx));
            try (FileOutputStream out = new FileOutputStream(csv);){
                IReportVisitor coverageVisitor = new CSVFormatter().createVisitor((OutputStream)out);
                coverageVisitor.visitBundle(builder.getBundle("JQF"), null);
                coverageVisitor.visitEnd();
                out.flush();
            }
        }
        catch (Exception e) {
            System.err.println(e);
        }
    }
}

