/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.util.Counter;
import edu.berkeley.cs.jqf.fuzz.util.NonZeroCachingCounter;
import edu.berkeley.cs.jqf.instrument.tracing.events.BranchEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.CallEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEvent;
import edu.berkeley.cs.jqf.instrument.tracing.events.TraceEventVisitor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class Coverage
implements TraceEventVisitor {
    private final int COVERAGE_MAP_SIZE = 65535;
    private final Counter counter = new NonZeroCachingCounter(65535);
    private static int[] HOB_CACHE = new int[1024];

    public Coverage() {
    }

    public Coverage(Coverage that) {
        for (int idx = 0; idx < 65535; ++idx) {
            this.counter.setAtIndex(idx, that.counter.getAtIndex(idx));
        }
    }

    public int size() {
        return 65535;
    }

    public void handleEvent(TraceEvent e) {
        e.applyVisitor((TraceEventVisitor)this);
    }

    public void visitBranchEvent(BranchEvent b) {
        this.counter.increment1(b.getIid(), b.getArm());
    }

    public void visitCallEvent(CallEvent e) {
        this.counter.increment(e.getIid());
    }

    public int getNonZeroCount() {
        return this.counter.getNonZeroSize();
    }

    public Collection<Integer> getCovered() {
        return this.counter.getNonZeroIndices();
    }

    public Collection<?> computeNewCoverage(Coverage baseline) {
        ArrayList<Integer> newCoverage = new ArrayList<Integer>();
        for (int idx : this.counter.getNonZeroIndices()) {
            if (baseline.counter.getAtIndex(idx) != 0) continue;
            newCoverage.add(idx);
        }
        return newCoverage;
    }

    public void clear() {
        this.counter.clear();
    }

    private static int computeHob(int num) {
        if (num == 0) {
            return 0;
        }
        int ret = 1;
        while ((num >>= 1) != 0) {
            ret <<= 1;
        }
        return ret;
    }

    private static int hob(int num) {
        if (num < HOB_CACHE.length) {
            return HOB_CACHE[num];
        }
        return Coverage.computeHob(num);
    }

    public boolean updateBits(Coverage that) {
        boolean changed = false;
        if (that.counter.hasNonZeros()) {
            for (int idx = 0; idx < 65535; ++idx) {
                int before = this.counter.getAtIndex(idx);
                int after = before | Coverage.hob(that.counter.getAtIndex(idx));
                if (after == before) continue;
                this.counter.setAtIndex(idx, after);
                changed = true;
            }
        }
        return changed;
    }

    public int hashCode() {
        return Arrays.hashCode(this.counter.counts);
    }

    public int nonZeroHashCode() {
        return this.counter.getNonZeroIndices().hashCode();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("Coverage counts: \n");
        for (int i = 0; i < this.counter.counts.length; ++i) {
            if (this.counter.counts[i] == 0) continue;
            sb.append(i);
            sb.append("->");
            sb.append(this.counter.counts[i]);
            sb.append('\n');
        }
        return sb.toString();
    }

    static {
        for (int i = 0; i < HOB_CACHE.length; ++i) {
            Coverage.HOB_CACHE[i] = Coverage.computeHob(i);
        }
    }
}

