/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class IOUtils {
    public static File[] resolveInputFileOrDirectory(File file) throws FileNotFoundException {
        if (file == null) {
            return null;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            Arrays.sort(files, Comparator.comparing(File::getName));
            return files;
        }
        if (file.isFile()) {
            return new File[]{file};
        }
        throw new FileNotFoundException("Could not find file: " + file);
    }

    public static File createDirectory(File parent, String name) throws IOException {
        File newDir = new File(parent, name);
        return IOUtils.createDirectory(newDir);
    }

    public static File createDirectory(File newDir) throws IOException {
        newDir.mkdirs();
        if (!newDir.isDirectory() || !newDir.canWrite()) {
            throw new IOException("Could not create directory: " + newDir.getAbsolutePath());
        }
        return newDir;
    }
}

