/*
 * Decompiled with CFR 0.152.
 */
package edu.berkeley.cs.jqf.fuzz.util;

import edu.berkeley.cs.jqf.fuzz.util.Counter;
import java.util.ArrayList;
import java.util.Collection;

public class NonZeroCachingCounter
extends Counter {
    private int nonZeroCount = 0;
    private Collection<Integer> nonZeroIndices = new ArrayList<Integer>();

    public NonZeroCachingCounter(int size) {
        super(size);
    }

    @Override
    public void clear() {
        for (int idx : this.nonZeroIndices) {
            this.counts[idx] = 0;
        }
        this.nonZeroCount = 0;
        this.nonZeroIndices.clear();
    }

    @Override
    public int incrementAtIndex(int index, int delta) {
        int newValue = super.incrementAtIndex(index, delta);
        if (newValue == delta) {
            this.nonZeroIndices.add(index);
            ++this.nonZeroCount;
        }
        return newValue;
    }

    @Override
    public int getNonZeroSize() {
        return this.nonZeroCount;
    }

    @Override
    public boolean hasNonZeros() {
        return this.nonZeroCount > 0;
    }

    @Override
    public Collection<Integer> getNonZeroIndices() {
        return this.nonZeroIndices;
    }

    @Override
    public Collection<Integer> getNonZeroValues() {
        ArrayList<Integer> values = new ArrayList<Integer>(this.size / 2);
        for (int idx : this.nonZeroIndices) {
            int count = this.counts[idx];
            assert (count != 0);
            values.add(count);
        }
        return values;
    }

    @Override
    public void setAtIndex(int index, int newValue) {
        int oldValue = this.counts[index];
        super.setAtIndex(index, newValue);
        if (oldValue == 0 && newValue != 0) {
            this.nonZeroIndices.add(index);
            ++this.nonZeroCount;
        }
    }
}

