/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.assertj.SoftAssertions;
import edu.hm.hafner.util.ResourceTest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractParserTest
extends ResourceTest {
    protected static final String DEFAULT_CATEGORY = new IssueBuilder().build().getCategory();
    private final String fileWithIssuesName;

    protected AbstractParserTest(String fileWithIssuesName) {
        this.fileWithIssuesName = fileWithIssuesName;
    }

    protected String getFileWithIssuesName() {
        return this.fileWithIssuesName;
    }

    @Test
    void shouldParseAllIssues() {
        Report report = this.parseDefaultFile();
        SoftAssertions.assertSoftly(softly -> this.assertThatIssuesArePresent(report, (SoftAssertions)((Object)softly)));
    }

    protected Report parseDefaultFile() {
        return this.createParser().parse(this.getDefaultFile(), StandardCharsets.UTF_8);
    }

    @Test
    void shouldBeSerializable() throws IOException {
        IssueParser parser = this.createParser();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(out);){
            stream.writeObject(parser);
        }
        Assertions.assertThat((byte[])out.toByteArray()).isNotEmpty();
    }

    protected Report parse(String fileName) {
        return this.createParser().parse(this.getResourceAsFile(fileName), StandardCharsets.UTF_8);
    }

    protected abstract void assertThatIssuesArePresent(Report var1, SoftAssertions var2);

    protected abstract IssueParser createParser();

    protected Path getDefaultFile() {
        return this.getResourceAsFile(this.fileWithIssuesName);
    }
}

