/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.TreeString;
import edu.hm.hafner.util.TreeStringBuilder;
import java.util.ArrayList;
import java.util.Random;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

class TreeStringBuilderTest {
    TreeStringBuilderTest() {
    }

    @Test
    void shouldCreateSimpleTreeStringsWithBuilder() {
        TreeStringBuilder builder = new TreeStringBuilder();
        Assertions.assertThat((Object)builder.intern("foo")).hasToString("foo");
        TreeString treeString = builder.intern("foo/bar/zot");
        Assertions.assertThat((Object)treeString).hasToString("foo/bar/zot");
        Assertions.assertThat((Object)builder.intern(treeString)).hasToString("foo/bar/zot");
        Assertions.assertThat((Object)builder.intern("")).hasToString("");
        Assertions.assertThat((Object)builder.intern("foo/bar/xxx")).hasToString("foo/bar/xxx");
        Assertions.assertThat((Object)treeString).hasToString("foo/bar/zot");
        Assertions.assertThat((boolean)builder.intern("").isBlank()).isTrue();
        Assertions.assertThat((Object)TreeString.valueOf((String)"foo/bar/zot")).hasToString("foo/bar/zot");
    }

    @Test
    void shouldCreateRandomTreeStrings() {
        int i;
        String[] dictionary = new String[]{"aa", "b", "aba", "ba"};
        TreeStringBuilder builder = new TreeStringBuilder();
        Random random = new Random(0L);
        ArrayList<String> a = new ArrayList<String>();
        ArrayList<TreeString> o = new ArrayList<TreeString>();
        for (i = 0; i < 1000; ++i) {
            StringBuilder b = new StringBuilder();
            for (int j = 0; j < random.nextInt(10) + 3; ++j) {
                b.append(dictionary[random.nextInt(4)]);
            }
            String s = b.toString();
            a.add(s);
            TreeString p = builder.intern(s);
            Assertions.assertThat((Object)p).hasToString(s);
            o.add(p);
        }
        for (i = 0; i < a.size(); ++i) {
            Assertions.assertThat((Object)((TreeString)o.get(i))).hasToString((String)a.get(i));
        }
        builder.dedup();
        for (i = 0; i < a.size(); ++i) {
            Assertions.assertThat((Object)((TreeString)o.get(i))).hasToString((String)a.get(i));
        }
    }
}

