/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.assertj.SoftAssertions;
import edu.hm.hafner.util.ResourceTest;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.ObjectOutputStream;
import java.nio.charset.StandardCharsets;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

public abstract class AbstractParserTest
extends ResourceTest {
    protected static final String DEFAULT_CATEGORY = new IssueBuilder().build().getCategory();
    private final String fileWithIssuesName;

    protected AbstractParserTest(String fileWithIssuesName) {
        this.fileWithIssuesName = fileWithIssuesName;
    }

    protected String getFileWithIssuesName() {
        return this.fileWithIssuesName;
    }

    @Test
    void shouldParseAllIssues() {
        Report report = this.parseDefaultFile();
        SoftAssertions.assertSoftly(softly -> this.assertThatIssuesArePresent(report, (SoftAssertions)((Object)softly)));
    }

    protected Report parseDefaultFile() {
        return this.createParser().parse(this.getDefaultFileFactory());
    }

    @Test
    void shouldBeSerializable() throws IOException {
        IssueParser parser = this.createParser();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try (ObjectOutputStream stream = new ObjectOutputStream(out);){
            stream.writeObject(parser);
        }
        Assertions.assertThat((byte[])out.toByteArray()).isNotEmpty();
    }

    protected Report parse(String fileName) {
        return this.createParser().parse(this.createReaderFactory(fileName));
    }

    protected abstract void assertThatIssuesArePresent(Report var1, SoftAssertions var2);

    protected abstract IssueParser createParser();

    protected ReaderFactory getDefaultFileFactory() {
        return this.createReaderFactory(this.fileWithIssuesName);
    }

    protected static ReaderFactory createReaderFactory(InputStream inputStream, String fileName) {
        ReaderFactory readerFactory = AbstractParserTest.createReaderFactory();
        Mockito.when((Object)readerFactory.getFileName()).thenReturn((Object)fileName);
        Mockito.when((Object)readerFactory.create()).thenAnswer(invocation -> new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        return readerFactory;
    }

    protected static ReaderFactory createReaderFactory() {
        ReaderFactory readerFactory = (ReaderFactory)Mockito.mock(ReaderFactory.class);
        Mockito.when((Object)readerFactory.readDocument()).thenCallRealMethod();
        Mockito.when((Object)readerFactory.readString()).thenCallRealMethod();
        Mockito.when((Object)readerFactory.readStream()).thenCallRealMethod();
        Mockito.when((Object)readerFactory.getCharset()).thenReturn((Object)StandardCharsets.UTF_8);
        return readerFactory;
    }

    protected ReaderFactory createReaderFactory(String fileName) {
        return AbstractParserTest.createReaderFactory(this.asInputStream(fileName), fileName);
    }
}

