/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.util;

import edu.hm.hafner.util.PathUtil;
import edu.hm.hafner.util.ResourceTest;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;

@SuppressFBWarnings(value={"DMI"})
class PathUtilTest
extends ResourceTest {
    private static final String NOT_EXISTING = "/should/not/exist";
    private static final String ILLEGAL = "\u0000 Null-Byte";
    private static final String FILE_NAME = "fileName.txt";

    PathUtilTest() {
    }

    @Test
    void shouldReturnFallback() {
        PathUtil pathUtil = new PathUtil();
        Assertions.assertThat((String)pathUtil.getAbsolutePath(NOT_EXISTING)).isEqualTo((Object)NOT_EXISTING);
        Assertions.assertThat((String)pathUtil.getAbsolutePath("C:\\should\\not\\exist")).isEqualTo((Object)"C:/should/not/exist");
        Assertions.assertThat((String)pathUtil.getAbsolutePath(ILLEGAL)).isEqualTo((Object)ILLEGAL);
    }

    @Test
    void shouldConvertToAbsolute() {
        PathUtil pathUtil = new PathUtil();
        Assertions.assertThat((String)pathUtil.createAbsolutePath(null, FILE_NAME)).isEqualTo((Object)FILE_NAME);
        Assertions.assertThat((String)pathUtil.createAbsolutePath("", FILE_NAME)).isEqualTo((Object)FILE_NAME);
        Assertions.assertThat((String)pathUtil.createAbsolutePath("/", FILE_NAME)).isEqualTo((Object)"/fileName.txt");
        Assertions.assertThat((String)pathUtil.createAbsolutePath("/tmp", FILE_NAME)).isEqualTo((Object)"/tmp/fileName.txt");
        Assertions.assertThat((String)pathUtil.createAbsolutePath("/tmp/", FILE_NAME)).isEqualTo((Object)"/tmp/fileName.txt");
    }

    @Test
    void shouldSkipAlreadyAbsoluteOnUnix() {
        Assumptions.assumeThat((boolean)this.isWindows()).isFalse();
        PathUtil pathUtil = new PathUtil();
        Assertions.assertThat((String)pathUtil.createAbsolutePath("/tmp/", "/tmp/file.txt")).isEqualTo((Object)"/tmp/file.txt");
    }

    @Test
    void shouldSkipAlreadyAbsoluteOnWindows() {
        Assumptions.assumeThat((boolean)this.isWindows()).isTrue();
        PathUtil pathUtil = new PathUtil();
        Assertions.assertThat((String)pathUtil.createAbsolutePath("C:\\tmp", "C:\\tmp\\file.txt")).isEqualTo((Object)"C:/tmp/file.txt");
    }
}

