/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.apache.commons.io.input.BOMInputStream;

public class FileReaderFactory
extends ReaderFactory {
    private final Path file;
    private final String fileName;

    public FileReaderFactory(Path file, @CheckForNull Charset charset) {
        super(charset);
        this.file = file;
        this.fileName = file.toAbsolutePath().toString().replace('\\', '/');
    }

    @Override
    @MustBeClosed
    public Reader create() {
        try {
            InputStream inputStream = Files.newInputStream(this.file, new OpenOption[0]);
            return new InputStreamReader((InputStream)new BOMInputStream(inputStream), this.getCharset());
        }
        catch (FileNotFoundException | InvalidPathException exception) {
            throw new ParsingException(exception, "Can't find file: " + this.fileName);
        }
        catch (IOException | UncheckedIOException exception) {
            throw new ParsingException(exception, "Can't scan file for issues: " + this.fileName);
        }
    }

    @Override
    public String getFileName() {
        return this.fileName;
    }
}

