/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.LineRangeList;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.IntegerParser;
import edu.hm.hafner.util.PathUtil;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.Optional;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;

public class IssueBuilder {
    private int lineStart = 0;
    private int lineEnd = 0;
    private int columnStart = 0;
    private int columnEnd = 0;
    @CheckForNull
    private LineRangeList lineRanges;
    @CheckForNull
    private String fileName;
    @CheckForNull
    private String directory;
    @CheckForNull
    private String category;
    @CheckForNull
    private String type;
    @CheckForNull
    private Severity severity;
    @CheckForNull
    private String message;
    @CheckForNull
    private String description;
    @CheckForNull
    private String packageName;
    @CheckForNull
    private String moduleName;
    @CheckForNull
    private String origin;
    @CheckForNull
    private String reference;
    @CheckForNull
    private String fingerprint;
    @CheckForNull
    private Serializable additionalProperties;
    private UUID id = UUID.randomUUID();

    public IssueBuilder setId(UUID id) {
        this.id = id;
        return this;
    }

    public IssueBuilder setAdditionalProperties(@CheckForNull Serializable additionalProperties) {
        this.additionalProperties = additionalProperties;
        return this;
    }

    public IssueBuilder setFingerprint(@CheckForNull String fingerprint) {
        this.fingerprint = fingerprint;
        return this;
    }

    public IssueBuilder setFileName(@CheckForNull String fileName) {
        this.fileName = StringUtils.isBlank((CharSequence)fileName) ? "" : new PathUtil().createAbsolutePath(this.directory, fileName);
        return this;
    }

    public IssueBuilder setDirectory(@CheckForNull String directory) {
        this.directory = directory;
        return this;
    }

    public IssueBuilder setLineStart(@CheckForNull int lineStart) {
        this.lineStart = lineStart;
        return this;
    }

    public IssueBuilder setLineStart(@CheckForNull String lineStart) {
        this.lineStart = IntegerParser.parseInt(lineStart);
        return this;
    }

    public IssueBuilder setLineEnd(@CheckForNull int lineEnd) {
        this.lineEnd = lineEnd;
        return this;
    }

    public IssueBuilder setLineEnd(@CheckForNull String lineEnd) {
        this.lineEnd = IntegerParser.parseInt(lineEnd);
        return this;
    }

    public IssueBuilder setColumnStart(int columnStart) {
        this.columnStart = columnStart;
        return this;
    }

    public IssueBuilder setColumnStart(String columnStart) {
        this.columnStart = IntegerParser.parseInt(columnStart);
        return this;
    }

    public IssueBuilder setColumnEnd(int columnEnd) {
        this.columnEnd = columnEnd;
        return this;
    }

    public IssueBuilder setColumnEnd(String columnEnd) {
        this.columnEnd = IntegerParser.parseInt(columnEnd);
        return this;
    }

    public IssueBuilder setCategory(@CheckForNull String category) {
        this.category = category;
        return this;
    }

    public IssueBuilder setType(@CheckForNull String type) {
        this.type = type;
        return this;
    }

    public IssueBuilder setPackageName(@CheckForNull String packageName) {
        this.packageName = packageName;
        return this;
    }

    public IssueBuilder setModuleName(@CheckForNull String moduleName) {
        this.moduleName = moduleName;
        return this;
    }

    public IssueBuilder setOrigin(@CheckForNull String origin) {
        this.origin = origin;
        return this;
    }

    public IssueBuilder setReference(@CheckForNull String reference) {
        this.reference = reference;
        return this;
    }

    public IssueBuilder setSeverity(@CheckForNull Severity severity) {
        this.severity = severity;
        return this;
    }

    public IssueBuilder setMessage(@CheckForNull String message) {
        this.message = message;
        return this;
    }

    public IssueBuilder setDescription(@CheckForNull String description) {
        this.description = description;
        return this;
    }

    public IssueBuilder setLineRanges(LineRangeList lineRanges) {
        this.lineRanges = new LineRangeList(lineRanges);
        return this;
    }

    public IssueBuilder copy(Issue copy) {
        this.fileName = copy.getFileName();
        this.lineStart = copy.getLineStart();
        this.lineEnd = copy.getLineEnd();
        this.columnStart = copy.getColumnStart();
        this.columnEnd = copy.getColumnEnd();
        this.lineRanges = copy.getLineRanges();
        this.category = copy.getCategory();
        this.type = copy.getType();
        this.severity = copy.getSeverity();
        this.message = copy.getMessage();
        this.description = copy.getDescription();
        this.packageName = copy.getPackageName();
        this.moduleName = copy.getModuleName();
        this.origin = copy.getOrigin();
        this.reference = copy.getReference();
        this.fingerprint = copy.getFingerprint();
        this.additionalProperties = copy.getAdditionalProperties();
        return this;
    }

    public Issue build() {
        Issue issue = new Issue(this.fileName, this.lineStart, this.lineEnd, this.columnStart, this.columnEnd, this.lineRanges, this.category, this.type, this.packageName, this.moduleName, this.severity, this.message, this.description, this.origin, this.reference, this.fingerprint, this.additionalProperties, this.id);
        this.id = UUID.randomUUID();
        return issue;
    }

    public Optional<Issue> buildOptional() {
        return Optional.of(this.build());
    }
}

