/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.SecureDigester;
import edu.hm.hafner.util.PathUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.commons.lang3.StringUtils;
import org.xml.sax.SAXException;

public class ModuleDetector {
    private static final String PLUS = ", ";
    private static final String BACK_SLASH = "\\";
    private static final String SLASH = "/";
    private static final String ALL_DIRECTORIES = "**/";
    private static final String BUNDLE_VENDOR = "Bundle-Vendor";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String REPLACEMENT_CHAR = "%";
    static final String MAVEN_POM = "pom.xml";
    static final String ANT_PROJECT = "build.xml";
    static final String OSGI_BUNDLE = "META-INF/MANIFEST.MF";
    private static final String PATTERN = "**/pom.xml, **/build.xml, **/META-INF/MANIFEST.MF";
    static final String PLUGIN_PROPERTIES = "plugin.properties";
    static final String BUNDLE_PROPERTIES = "OSGI-INF/l10n/bundle.properties";
    private final FileSystem factory;
    private final Map<String, String> fileNameToModuleName;
    private final List<String> prefixes;

    public ModuleDetector(Path workspace, FileSystem fileSystem) {
        this.factory = fileSystem;
        this.fileNameToModuleName = this.createFilesToModuleMapping(workspace);
        this.prefixes = new ArrayList<String>(this.fileNameToModuleName.keySet());
        Collections.sort(this.prefixes);
    }

    private Map<String, String> createFilesToModuleMapping(Path workspace) {
        String[] projects;
        HashMap<String, String> mapping = new HashMap<String, String>();
        for (String fileName : projects = this.find(workspace)) {
            if (!fileName.endsWith(ANT_PROJECT)) continue;
            this.addMapping(mapping, fileName, ANT_PROJECT, this.parseBuildXml(fileName));
        }
        for (String fileName : projects) {
            if (!fileName.endsWith(MAVEN_POM)) continue;
            this.addMapping(mapping, fileName, MAVEN_POM, this.parsePom(fileName));
        }
        for (String fileName : projects) {
            if (!fileName.endsWith(OSGI_BUNDLE)) continue;
            this.addMapping(mapping, fileName, OSGI_BUNDLE, this.parseManifest(fileName));
        }
        return mapping;
    }

    private void addMapping(Map<String, String> mapping, String fileName, String suffix, String moduleName) {
        if (StringUtils.isNotBlank((CharSequence)moduleName)) {
            mapping.put(StringUtils.substringBeforeLast((String)fileName, (String)suffix), moduleName);
        }
    }

    public String guessModuleName(String originalFileName) {
        String fullPath = originalFileName.replace('\\', '/');
        String guessedModule = "";
        for (String path : this.prefixes) {
            if (!fullPath.startsWith(path)) continue;
            guessedModule = this.fileNameToModuleName.get(path);
        }
        return guessedModule;
    }

    private String[] find(Path path) {
        String[] relativeFileNames = this.factory.find(path, PATTERN);
        String[] absoluteFileNames = new String[relativeFileNames.length];
        for (int file = 0; file < absoluteFileNames.length; ++file) {
            String relativePath = this.normalizePath(relativeFileNames[file]);
            absoluteFileNames[file] = relativePath.startsWith(SLASH) ? relativePath : new PathUtil().getAbsolutePath(path) + SLASH + relativePath;
        }
        return absoluteFileNames;
    }

    private String normalizePath(String fileName) {
        return fileName.replace(BACK_SLASH, SLASH);
    }

    private String parseBuildXml(String buildXml) {
        String string;
        block8: {
            InputStream file = this.factory.open(buildXml);
            Throwable throwable = null;
            try {
                SecureDigester digester = new SecureDigester(ModuleDetector.class);
                digester.push(new StringBuilder());
                String xPath = "project";
                digester.addCallMethod(xPath, "append", 1);
                digester.addCallParam(xPath, 0, "name");
                StringBuilder result = (StringBuilder)digester.parse(file);
                string = result.toString();
                if (file == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (file != null) {
                            ModuleDetector.$closeResource(throwable, file);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException | InvalidPathException | SAXException exception) {
                    return "";
                }
            }
            ModuleDetector.$closeResource(throwable, file);
        }
        return string;
    }

    private String parsePom(String pom) {
        String name = this.parsePomAttribute(pom, "name");
        return (String)StringUtils.defaultIfBlank((CharSequence)name, (CharSequence)this.parsePomAttribute(pom, "artifactId"));
    }

    private String parsePomAttribute(String pom, String tagName) {
        String string;
        block8: {
            InputStream file = this.factory.open(pom);
            Throwable throwable = null;
            try {
                SecureDigester digester = new SecureDigester(ModuleDetector.class);
                digester.push(new StringBuilder());
                digester.addCallMethod("project/" + tagName, "append", 0);
                StringBuilder result = (StringBuilder)digester.parse(file);
                string = result.toString();
                if (file == null) break block8;
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (file != null) {
                            ModuleDetector.$closeResource(throwable, file);
                        }
                        throw throwable3;
                    }
                }
                catch (IOException | InvalidPathException | SAXException exception) {
                    return "";
                }
            }
            ModuleDetector.$closeResource(throwable, file);
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String parseManifest(String manifestFile) {
        try (InputStream file = this.factory.open(manifestFile);){
            Manifest manifest = new Manifest(file);
            Attributes attributes = manifest.getMainAttributes();
            Properties properties = this.readProperties(StringUtils.substringBefore((String)manifestFile, (String)OSGI_BUNDLE));
            String name = this.getLocalizedValue(attributes, properties, BUNDLE_NAME);
            if (StringUtils.isNotBlank((CharSequence)name)) {
                String string2 = name;
                return string2;
            }
            String string = this.getSymbolicName(attributes, properties);
            return string;
        }
        catch (IOException | InvalidPathException exception) {
            return "";
        }
    }

    private String getLocalizedValue(Attributes attributes, Properties properties, String bundleName) {
        String value = attributes.getValue(bundleName);
        if (StringUtils.startsWith((CharSequence)StringUtils.trim((String)value), (CharSequence)REPLACEMENT_CHAR)) {
            return properties.getProperty(StringUtils.substringAfter((String)value, (String)REPLACEMENT_CHAR));
        }
        return value;
    }

    private Properties readProperties(String path) {
        Properties properties = new Properties();
        this.readProperties(path, properties, PLUGIN_PROPERTIES);
        this.readProperties(path, properties, BUNDLE_PROPERTIES);
        return properties;
    }

    private void readProperties(String path, Properties properties, String fileName) {
        try (InputStream file = this.factory.open(path + SLASH + fileName);){
            properties.load(file);
        }
        catch (IOException | InvalidPathException exception) {
            // empty catch block
        }
    }

    private String getSymbolicName(Attributes attributes, Properties properties) {
        String symbolicName = StringUtils.substringBefore((String)attributes.getValue(BUNDLE_SYMBOLIC_NAME), (String)";");
        if (StringUtils.isNotBlank((CharSequence)symbolicName)) {
            String vendor = this.getLocalizedValue(attributes, properties, BUNDLE_VENDOR);
            if (StringUtils.isNotBlank((CharSequence)vendor)) {
                return symbolicName + " (" + vendor + ")";
            }
            return symbolicName;
        }
        return "";
    }

    public static interface FileSystem {
        public String[] find(Path var1, String var2);

        @MustBeClosed
        public InputStream open(String var1) throws IOException, InvalidPathException;
    }
}

