/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.MustBeClosed;
import edu.hm.hafner.analysis.ParsingException;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.InvalidPathException;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.commons.lang3.ObjectUtils;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public abstract class ReaderFactory {
    private static final Function<String, String> IDENTITY = Function.identity();
    @CheckForNull
    private final Charset charset;
    private final Function<String, String> lineMapper;

    public ReaderFactory(@CheckForNull Charset charset) {
        this(charset, IDENTITY);
    }

    public ReaderFactory(@CheckForNull Charset charset, Function<String, String> lineMapper) {
        this.charset = charset;
        this.lineMapper = lineMapper;
    }

    public abstract String getFileName();

    @MustBeClosed
    public abstract Reader create();

    @MustBeClosed
    @SuppressFBWarnings(value={"OS_OPEN_STREAM"})
    public Stream<String> readStream() {
        BufferedReader reader = new BufferedReader(this.create());
        Stream stringStream = (Stream)reader.lines().onClose(this.closeReader(reader));
        if (this.hasLineMapper()) {
            return stringStream.map(this.lineMapper);
        }
        return stringStream;
    }

    private Runnable closeReader(AutoCloseable closeable) {
        return () -> {
            try {
                closeable.close();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="test stub")
    private boolean hasLineMapper() {
        return this.lineMapper != null && this.lineMapper != IDENTITY;
    }

    public String readString() {
        try (Stream<String> lines = this.readStream();){
            String string = lines.collect(Collectors.joining("\n"));
            return string;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Document readDocument() {
        try (Reader reader = this.create();){
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document document = docBuilder.parse(new InputSource((InputStream)new ReaderInputStream(reader, this.getCharset())));
            return document;
        }
        catch (IOException | InvalidPathException | ParserConfigurationException | SAXException e) {
            throw new ParsingException(e);
        }
    }

    public Charset getCharset() {
        return (Charset)ObjectUtils.defaultIfNull((Object)this.charset, (Object)StandardCharsets.UTF_8);
    }
}

