/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.RegexpParser;
import edu.hm.hafner.analysis.Report;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public abstract class RegexpLineParser
extends RegexpParser {
    private static final long serialVersionUID = 5932670979793111138L;
    private static final Pattern MAKE_PATH = Pattern.compile(".*make(?:\\[\\d+])?: Entering directory [`'](.*)['`]");
    private int currentLine = 0;
    private String currentDirectory = "";

    protected RegexpLineParser(String warningPattern) {
        super(warningPattern, false);
    }

    @Override
    public Report parse(ReaderFactory reader) throws ParsingException {
        Report report = new Report();
        try (Stream<String> lines = reader.readStream();){
            Iterator iterator = lines.iterator();
            this.currentLine = 1;
            while (iterator.hasNext()) {
                String line = (String)iterator.next();
                Matcher makeLineMatcher = MAKE_PATH.matcher(line);
                if (makeLineMatcher.matches()) {
                    this.currentDirectory = makeLineMatcher.group(1);
                }
                this.findIssues(line, report);
                ++this.currentLine;
            }
        }
        return this.postProcess(report);
    }

    @Override
    protected IssueBuilder configureIssueBuilder(IssueBuilder builder) {
        return builder.setDirectory(this.currentDirectory);
    }

    protected Report postProcess(Report report) {
        return report;
    }

    protected int getCurrentLine() {
        return this.currentLine;
    }
}

