/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.FormatMethod;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.util.Ensure;
import edu.hm.hafner.util.NoSuchElementException;
import edu.hm.hafner.util.VisibleForTesting;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Spliterators;
import java.util.UUID;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.eclipse.collections.api.list.ImmutableList;
import org.eclipse.collections.impl.factory.Lists;

public class Report
implements Iterable<Issue>,
Serializable {
    private static final long serialVersionUID = 1L;
    @VisibleForTesting
    static final String DEFAULT_ID = "-";
    private final Set<Issue> elements = new LinkedHashSet<Issue>();
    private final List<String> infoMessages = new ArrayList<String>();
    private final List<String> errorMessages = new ArrayList<String>();
    private int duplicatesSize = 0;

    public Report() {
    }

    public Report(Report ... reports) {
        Ensure.that(reports).isNotEmpty("No reports given.", new Object[0]);
        for (Report other : reports) {
            this.copyIssuesAndProperties(other, this);
        }
    }

    public Report(Collection<Report> reports) {
        Ensure.that(reports).isNotEmpty("No reports given.", new Object[0]);
        for (Report other : reports) {
            this.copyIssuesAndProperties(other, this);
        }
    }

    public Report add(Issue issue) {
        if (this.elements.contains(issue)) {
            ++this.duplicatesSize;
        } else {
            this.elements.add(issue);
        }
        return this;
    }

    public Report addAll(Issue issue, Issue ... additionalIssues) {
        this.add(issue);
        for (Issue additional : additionalIssues) {
            this.add(additional);
        }
        return this;
    }

    public Report addAll(Collection<? extends Issue> issues) {
        for (Issue issue : issues) {
            this.add(issue);
        }
        return this;
    }

    public Report addAll(Report ... reports) {
        Ensure.that(reports).isNotEmpty("No reports given.", new Object[0]);
        for (Report other : reports) {
            this.copyIssuesAndProperties(other, this);
        }
        return this;
    }

    public Issue remove(UUID issueId) {
        for (Issue element : this.elements) {
            if (!element.getId().equals(issueId)) continue;
            this.elements.remove(element);
            return element;
        }
        throw new NoSuchElementException("No issue found with id %s.", issueId);
    }

    public Issue findById(UUID issueId) {
        for (Issue issue : this.elements) {
            if (!issue.getId().equals(issueId)) continue;
            return issue;
        }
        throw new NoSuchElementException("No issue found with id %s.", issueId);
    }

    public Set<Issue> findByProperty(Predicate<? super Issue> criterion) {
        return this.filterElements(criterion).collect(Collectors.toSet());
    }

    public Report filter(Predicate<? super Issue> criterion) {
        Report filtered = this.copyEmptyInstance();
        filtered.addAll(this.filterElements(criterion).collect(Collectors.toList()));
        return filtered;
    }

    private Stream<Issue> filterElements(Predicate<? super Issue> criterion) {
        return this.elements.stream().filter(criterion);
    }

    @Override
    @NonNull
    public Iterator<Issue> iterator() {
        return Lists.immutable.withAll(this.elements).iterator();
    }

    public Stream<Issue> stream() {
        return StreamSupport.stream(Spliterators.spliterator(this.iterator(), 0L, 256), false);
    }

    public int size() {
        return this.elements.size();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public boolean isNotEmpty() {
        return !this.isEmpty();
    }

    public int getSize() {
        return this.size();
    }

    public int getDuplicatesSize() {
        return this.duplicatesSize;
    }

    public int getSizeOf(String severity) {
        return this.getSizeOf(Severity.valueOf(severity));
    }

    public int getSizeOf(Severity severity) {
        return this.elements.stream().filter((? super T issue) -> issue.getSeverity().equals(severity)).mapToInt(e -> 1).sum();
    }

    public Issue get(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("No such index " + index + " in " + this.toString());
        }
        Iterator<Issue> all = this.elements.iterator();
        for (int i = 0; i < index; ++i) {
            all.next();
        }
        return all.next();
    }

    public String toString() {
        return String.format("%d issues", this.size());
    }

    public Set<String> getModules() {
        return this.getProperties(Issue::getModuleName);
    }

    public boolean hasModules() {
        return this.hasProperty(this.getModules());
    }

    private boolean hasProperty(Set<String> propertyValues) {
        return propertyValues.size() > 1 || this.hasMeaningfulValues(propertyValues);
    }

    private boolean hasMeaningfulValues(Set<String> propertyValue) {
        return propertyValue.size() == 1 && !propertyValue.contains(DEFAULT_ID) && !propertyValue.contains("");
    }

    public Set<String> getPackages() {
        return this.getProperties(Issue::getPackageName);
    }

    public boolean hasPackages() {
        return this.hasProperty(this.getPackages());
    }

    public Set<String> getFiles() {
        return this.getProperties(Issue::getFileName);
    }

    public boolean hasFiles() {
        return this.hasProperty(this.getFiles());
    }

    public Set<String> getCategories() {
        return this.getProperties(Issue::getCategory);
    }

    public boolean hasCategories() {
        return this.hasProperty(this.getCategories());
    }

    public Set<String> getTypes() {
        return this.getProperties(Issue::getType);
    }

    public boolean hasTypes() {
        return this.hasProperty(this.getTypes());
    }

    public Set<String> getTools() {
        return this.getProperties(Issue::getOrigin);
    }

    public boolean hasTools() {
        return this.hasProperty(this.getTools());
    }

    public Set<Severity> getSeverities() {
        return this.getProperties(Issue::getSeverity);
    }

    public boolean hasSeverities() {
        return this.getSeverities().size() > 1;
    }

    public <T> Set<T> getProperties(Function<? super Issue, T> propertiesMapper) {
        return this.elements.stream().map(propertiesMapper).collect(Collectors.toSet());
    }

    public <T> Map<T, Integer> getPropertyCount(Function<? super Issue, T> propertiesMapper) {
        return this.elements.stream().collect(Collectors.groupingBy(propertiesMapper, Collectors.reducing(0, issue -> 1, Integer::sum)));
    }

    public Map<String, Report> groupByProperty(String propertyName) {
        Map<String, List<Issue>> issues = this.elements.stream().collect(Collectors.groupingBy(Issue.getPropertyValueGetter(propertyName)));
        return issues.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            Report report = new Report();
            report.addAll((Collection)e.getValue());
            return report;
        }));
    }

    public Report copy() {
        Report copied = new Report();
        this.copyIssuesAndProperties(this, copied);
        return copied;
    }

    private void copyIssuesAndProperties(Report source, Report destination) {
        destination.addAll(source.elements);
        this.copyProperties(source, destination);
    }

    private void copyProperties(Report source, Report destination) {
        destination.duplicatesSize += source.duplicatesSize;
        destination.infoMessages.addAll(source.infoMessages);
        destination.errorMessages.addAll(source.errorMessages);
    }

    public Report copyEmptyInstance() {
        Report empty = new Report();
        this.copyProperties(this, empty);
        return empty;
    }

    @FormatMethod
    public void logInfo(String format, Object ... args) {
        this.infoMessages.add(String.format(format, args));
    }

    @FormatMethod
    public void logError(String format, Object ... args) {
        this.errorMessages.add(String.format(format, args));
    }

    @FormatMethod
    public void logException(Exception exception, String format, Object ... args) {
        this.logError(format, args);
        Collections.addAll(this.errorMessages, ExceptionUtils.getRootCauseStackTrace((Throwable)exception));
    }

    public ImmutableList<String> getInfoMessages() {
        return Lists.immutable.ofAll(this.infoMessages);
    }

    public ImmutableList<String> getErrorMessages() {
        return Lists.immutable.ofAll(this.errorMessages);
    }

    public boolean hasErrors() {
        return !this.errorMessages.isEmpty();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Report report = (Report)o;
        if (this.duplicatesSize != report.duplicatesSize) {
            return false;
        }
        if (!this.elements.equals(report.elements)) {
            return false;
        }
        if (!this.infoMessages.equals(report.infoMessages)) {
            return false;
        }
        return this.errorMessages.equals(report.errorMessages);
    }

    public int hashCode() {
        int result = this.elements.hashCode();
        result = 31 * result + this.infoMessages.hashCode();
        result = 31 * result + this.errorMessages.hashCode();
        result = 31 * result + this.duplicatesSize;
        return result;
    }

    public static class IssueFilterBuilder {
        private final Collection<Predicate<Issue>> includeFilters = new ArrayList<Predicate<Issue>>();
        private final Collection<Predicate<Issue>> excludeFilters = new ArrayList<Predicate<Issue>>();

        private void addNewFilter(Collection<String> patterns, Function<Issue, String> propertyToFilter, FilterType type) {
            ArrayList<Predicate<Issue>> filters = new ArrayList<Predicate<Issue>>();
            for (String pattern : patterns) {
                filters.add(issueToFilter -> Pattern.compile(pattern).matcher((CharSequence)propertyToFilter.apply((Issue)issueToFilter)).matches() == (type == FilterType.INCLUDE));
            }
            if (type == FilterType.INCLUDE) {
                this.includeFilters.addAll(filters);
            } else {
                this.excludeFilters.addAll(filters);
            }
        }

        public Predicate<Issue> build() {
            return this.includeFilters.stream().reduce(Predicate::or).orElse(issue -> true).and(this.excludeFilters.stream().reduce(Predicate::and).orElse(issue -> true));
        }

        public IssueFilterBuilder setIncludeFileNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getFileName, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeFileNameFilter(String ... pattern) {
            return this.setIncludeFileNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeFileNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getFileName, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeFileNameFilter(String ... pattern) {
            return this.setExcludeFileNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludePackageNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getPackageName, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludePackageNameFilter(String ... pattern) {
            return this.setIncludePackageNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludePackageNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getPackageName, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludePackageNameFilter(String ... pattern) {
            return this.setExcludePackageNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludeModuleNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getModuleName, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeModuleNameFilter(String ... pattern) {
            return this.setIncludeModuleNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeModuleNameFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getModuleName, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeModuleNameFilter(String ... pattern) {
            return this.setExcludeModuleNameFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludeCategoryFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getCategory, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeCategoryFilter(String ... pattern) {
            return this.setIncludeCategoryFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeCategoryFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getCategory, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeCategoryFilter(String ... pattern) {
            return this.setExcludeCategoryFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setIncludeTypeFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getType, FilterType.INCLUDE);
            return this;
        }

        public IssueFilterBuilder setIncludeTypeFilter(String ... pattern) {
            return this.setIncludeTypeFilter(Arrays.asList(pattern));
        }

        public IssueFilterBuilder setExcludeTypeFilter(Collection<String> pattern) {
            this.addNewFilter(pattern, Issue::getType, FilterType.EXCLUDE);
            return this;
        }

        public IssueFilterBuilder setExcludeTypeFilter(String ... pattern) {
            return this.setExcludeTypeFilter(Arrays.asList(pattern));
        }

        static enum FilterType {
            INCLUDE,
            EXCLUDE;

        }
    }
}

