/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis;

import com.google.errorprone.annotations.Immutable;
import edu.hm.hafner.util.Ensure;
import edu.umd.cs.findbugs.annotations.CheckForNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.collections.api.set.ImmutableSet;
import org.eclipse.collections.impl.factory.Sets;

@Immutable
public class Severity
implements Serializable {
    private static final long serialVersionUID = 8921726169259131484L;
    public static final Severity ERROR = new Severity("ERROR");
    public static final Severity WARNING_HIGH = new Severity("HIGH");
    public static final Severity WARNING_NORMAL = new Severity("NORMAL");
    public static final Severity WARNING_LOW = new Severity("LOW");
    private static final ImmutableSet<Severity> ALL_SEVERITIES = Sets.immutable.of((Object)ERROR, (Object)WARNING_HIGH, (Object)WARNING_NORMAL, (Object)WARNING_LOW);
    private final String name;

    public static Severity valueOf(String name) {
        if (ERROR.equalsIgnoreCase(name)) {
            return ERROR;
        }
        if (WARNING_HIGH.equalsIgnoreCase(name)) {
            return WARNING_HIGH;
        }
        if (WARNING_NORMAL.equalsIgnoreCase(name)) {
            return WARNING_NORMAL;
        }
        if (WARNING_LOW.equalsIgnoreCase(name)) {
            return WARNING_LOW;
        }
        return new Severity(name);
    }

    public static Severity valueOf(@CheckForNull String severity, Severity defaultValue) {
        if (severity == null || ALL_SEVERITIES.stream().map(Severity::getName).noneMatch(name -> name.equals(severity))) {
            return defaultValue;
        }
        return Severity.valueOf(severity);
    }

    public static Collection<Severity> collectSeveritiesFrom(Severity minimumSeverity) {
        ArrayList<Severity> priorities = new ArrayList<Severity>();
        priorities.add(ERROR);
        if (minimumSeverity.equals(WARNING_HIGH)) {
            priorities.add(WARNING_HIGH);
        } else if (minimumSeverity.equals(WARNING_NORMAL)) {
            priorities.add(WARNING_HIGH);
            priorities.add(WARNING_NORMAL);
        } else if (minimumSeverity.equals(WARNING_LOW)) {
            priorities.add(WARNING_HIGH);
            priorities.add(WARNING_NORMAL);
            priorities.add(WARNING_LOW);
        }
        return priorities;
    }

    public static ImmutableSet<Severity> getPredefinedValues() {
        return ALL_SEVERITIES;
    }

    public Severity(String name) {
        Ensure.that(name).isNotBlank();
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.name;
    }

    public boolean equalsIgnoreCase(String severityName) {
        return this.getName().equalsIgnoreCase(severityName);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Severity severity = (Severity)o;
        return this.name.equals(severity.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

