/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class AjcParser
extends IssueParser {
    private static final long serialVersionUID = -9123765511497052454L;
    private static final Pattern ESCAPE_CHARACTERS = Pattern.compile("\u001b\\[.*\u001b\\[0m");
    private static final Pattern WARNING_TAG = Pattern.compile("\\[WARNING\\] ");
    static final String ADVICE = "Advice";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Report parse(ReaderFactory reader) throws ParsingException {
        try (Stream<String> lines = reader.readStream();){
            Report warnings = new Report();
            States state = States.START;
            IssueBuilder builder = new IssueBuilder();
            Iterator lineIterator = lines.iterator();
            while (lineIterator.hasNext()) {
                String line = (String)lineIterator.next();
                line = ESCAPE_CHARACTERS.matcher(line).replaceAll("");
                switch (state) {
                    case START: {
                        if (!line.startsWith("[INFO] Showing AJC message detail for messages of types")) break;
                        state = States.PARSING;
                        break;
                    }
                    case PARSING: {
                        if (!line.startsWith("[WARNING] ")) break;
                        state = States.WAITING_FOR_END;
                        this.fillMessageAndCategory(builder, line);
                        break;
                    }
                    case WAITING_FOR_END: {
                        if (line.startsWith("\t")) {
                            this.fillFileName(builder, line);
                            break;
                        }
                        if (!"".equals(line)) break;
                        state = States.PARSING;
                        warnings.add(builder.build());
                        break;
                    }
                }
            }
            Report report = warnings;
            return report;
        }
        catch (UncheckedIOException e) {
            throw new ParsingException(e);
        }
    }

    private void fillFileName(IssueBuilder builder, String line) {
        int indexOfColon = line.lastIndexOf(58);
        if (indexOfColon != -1) {
            builder.setFileName(line.substring(0, indexOfColon));
            if (line.length() > indexOfColon + 1) {
                builder.setLineStart(line.substring(indexOfColon + 1));
            }
        }
    }

    private void fillMessageAndCategory(IssueBuilder builder, String line) {
        String message = WARNING_TAG.matcher(line).replaceAll("");
        String category = message.contains("is deprecated") || message.contains("overrides a deprecated") ? "Deprecation" : (message.contains("adviceDidNotMatch") ? ADVICE : "");
        builder.setMessage(message);
        builder.setCategory(category);
    }

    private static enum States {
        START,
        PARSING,
        WAITING_FOR_END;

    }
}

