/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class AntJavacParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String ANT_JAVAC_WARNING_PATTERN = "^(?:.*\\[.*\\])?\\s*\\s*(.*java):(\\d*):\\s*(warning|error|\u8b66\u544a)\\s*:\\s*(?:\\[(\\w*)\\])?\\s*(.*)$|^\\s*\\[.*\\]\\s*warning.*\\]\\s*(.*\"(.*)\".*)$|^(.*class)\\s*:\\s*warning\\s*:\\s*(.*)$";

    public AntJavacParser() {
        super(ANT_JAVAC_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("warning") || line.contains("error") || line.contains("\u8b66\u544a");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        builder.setSeverity(this.mapSeverity(matcher.group(3)));
        if (StringUtils.isNotBlank((CharSequence)matcher.group(8))) {
            return builder.setFileName(matcher.group(8)).setLineStart(0).setCategory("").setMessage(matcher.group(9)).buildOptional();
        }
        if (StringUtils.isBlank((CharSequence)matcher.group(6))) {
            return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(Categories.guessCategoryIfEmpty(matcher.group(4), matcher.group(5))).setMessage(matcher.group(5)).buildOptional();
        }
        return builder.setFileName(matcher.group(7)).setLineStart(0).setCategory("Path").setMessage(matcher.group(6)).buildOptional();
    }

    private Severity mapSeverity(String type) {
        return "error".equalsIgnoreCase(type) ? Severity.ERROR : Severity.WARNING_NORMAL;
    }
}

