/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ClangParser
extends RegexpLineParser {
    private static final long serialVersionUID = -3015592762345283182L;
    private static final String CLANG_WARNING_PATTERN = "^\\s*(?:\\d+%)?([^%]*?):(\\d+):(?:(\\d+):)?(?:(?:\\{\\d+:\\d+-\\d+:\\d+\\})+:)?\\s*(warning|[^\\[\\]]*error):\\s*(.*?)(?:\\[([^\\[]*)\\])?$";
    private static final Pattern IGNORE_FORMAT = Pattern.compile("^-\\[.*\\].*$");

    public ClangParser() {
        super(CLANG_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String message = matcher.group(5);
        if (IGNORE_FORMAT.matcher(message).matches()) {
            return Optional.empty();
        }
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setColumnStart(matcher.group(3)).setCategory(matcher.group(6)).setMessage(message).setSeverity(this.mapPriority(matcher.group(4))).buildOptional();
    }

    private Severity mapPriority(String type) {
        if (type.contains("error")) {
            return Severity.WARNING_HIGH;
        }
        return Severity.WARNING_NORMAL;
    }
}

