/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.XmlElementUtil;
import edu.hm.hafner.analysis.parser.EclipseParser;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class EclipseXMLParser
extends IssueParser {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean accepts(ReaderFactory readerFactory) {
        return this.isXmlFile(readerFactory);
    }

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        try {
            Document doc = readerFactory.readDocument();
            XPathFactory xPathFactory = XPathFactory.newInstance();
            XPath xPath = xPathFactory.newXPath();
            IssueBuilder issueBuilder = new IssueBuilder();
            Report report = new Report();
            NodeList sources = (NodeList)xPath.evaluate("/compiler/sources/source[problems]", doc, XPathConstants.NODESET);
            for (Element source : XmlElementUtil.nodeListToList(sources)) {
                String fileName = xPath.evaluate("@path", source);
                issueBuilder.setFileName(fileName);
                NodeList problems = (NodeList)xPath.evaluate("problems/problem", source, XPathConstants.NODESET);
                for (Element problem : XmlElementUtil.nodeListToList(problems)) {
                    String colEnd;
                    String type = xPath.evaluate("@severity", problem);
                    if (type != null) {
                        issueBuilder.setSeverity(EclipseParser.mapTypeToSeverity(type));
                    }
                    issueBuilder.setLineStart(xPath.evaluate("@line", problem));
                    String colStart = xPath.evaluate("source_context/@sourceStart", problem);
                    if (colStart != null) {
                        issueBuilder.setColumnStart(Integer.parseInt(colStart) + 1);
                    }
                    if ((colEnd = xPath.evaluate("source_context/@sourceEnd", problem)) != null) {
                        issueBuilder.setColumnEnd(Integer.parseInt(colEnd) + 1);
                    }
                    String msg = xPath.evaluate("message/@value", problem);
                    issueBuilder.setMessage(msg);
                    report.add(issueBuilder.build());
                }
            }
            return report;
        }
        catch (XPathExpressionException e) {
            throw new ParsingException(e);
        }
    }
}

