/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpDocumentParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class GnuFortranParser
extends RegexpDocumentParser {
    private static final long serialVersionUID = 0L;
    private static final String GFORTRAN_MSG_PATTERN = "(?s)^([^\\n]+\\.[^:\\n]+):(\\d+)(?:\\.(\\d+)(?:-(\\d+))?)?:\\n(?:    Included at [^\\n]+\\n)*\\n[^\\n]+\\n[^\\n]+\\n(Warning|Error|Fatal Error|Internal Error at \\(1\\)):[\\s\\n]([^\\n]+)\\n";
    private static final Pattern LINE_PATTERN = Pattern.compile(" at \\(\\d\\)");

    public GnuFortranParser() {
        super(GFORTRAN_MSG_PATTERN, true);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String category = LINE_PATTERN.matcher(matcher.group(5)).replaceAll("");
        return builder.setFileName(matcher.group(1)).setColumnStart(matcher.group(3)).setColumnEnd(matcher.group(4)).setLineStart(matcher.group(2)).setCategory(category).setMessage(LINE_PATTERN.matcher(matcher.group(6)).replaceAll("")).setSeverity("Warning".equals(category) ? Severity.WARNING_NORMAL : Severity.WARNING_HIGH).buildOptional();
    }
}

