/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.IssueParser;
import edu.hm.hafner.analysis.ParsingException;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import edu.hm.hafner.analysis.XmlElementUtil;
import java.util.List;
import org.apache.commons.text.StringEscapeUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class IdeaInspectionParser
extends IssueParser {
    private static final long serialVersionUID = 3307389086106375473L;

    @Override
    public Report parse(ReaderFactory readerFactory) throws ParsingException {
        Document document = readerFactory.readDocument();
        Element rootElement = (Element)document.getElementsByTagName("problems").item(0);
        return this.parseProblems(XmlElementUtil.getNamedChildElements(rootElement, "problem"));
    }

    private Report parseProblems(List<Element> elements) {
        Report problems = new Report();
        for (Element element : elements) {
            String file = this.getChildValue(element, "file");
            Element problemClass = XmlElementUtil.getFirstElementByTagName(element, "problem_class");
            if (problemClass == null) continue;
            IssueBuilder builder = new IssueBuilder().setFileName(file).setLineStart(Integer.parseInt(this.getChildValue(element, "line"))).setCategory(StringEscapeUtils.unescapeXml((String)this.getValue(problemClass))).setMessage(StringEscapeUtils.unescapeXml((String)this.getChildValue(element, "description"))).setSeverity(this.getPriority(problemClass.getAttribute("severity")));
            problems.add(builder.build());
        }
        return problems;
    }

    private Severity getPriority(String severity) {
        Severity priority = Severity.WARNING_LOW;
        if ("WARNING".equals(severity)) {
            priority = Severity.WARNING_NORMAL;
        } else if ("ERROR".equals(severity)) {
            priority = Severity.WARNING_HIGH;
        }
        return priority;
    }

    private String getValue(Element element) {
        return element.getFirstChild().getNodeValue();
    }

    private String getChildValue(Element element, String childTag) {
        Node child;
        Element firstElement = XmlElementUtil.getFirstElementByTagName(element, childTag);
        if (firstElement != null && (child = firstElement.getFirstChild()) != null) {
            return child.getNodeValue();
        }
        return "-";
    }
}

