/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class IntelParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = 8409744276858003050L;
    private static final String INTEL_PATTERN = "^(.*)\\((\\d*)\\)?:(?:\\s*\\(col\\. (\\d+)\\))?.*((?:remark|warning|error)\\s*#*\\d*)\\s*:\\s*(.*)$";

    public IntelParser() {
        super(INTEL_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("warning") || line.contains("error") || line.contains("remark");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String category = StringUtils.capitalize((String)matcher.group(4));
        Severity priority = StringUtils.startsWith((CharSequence)category, (CharSequence)"Remark") ? Severity.WARNING_LOW : (StringUtils.startsWith((CharSequence)category, (CharSequence)"Error") ? Severity.WARNING_HIGH : Severity.WARNING_NORMAL);
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setColumnStart(matcher.group(3)).setCategory(category).setMessage(matcher.group(5)).setSeverity(priority).buildOptional();
    }
}

