/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;

public class JavacParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = 7199325311690082782L;
    private static final String JAVAC_WARNING_PATTERN = "^(?:\\[\\p{Alnum}*\\]\\s+)?(?:(?:\\[(WARNING|ERROR)\\]|w:)\\s+)([^\\[\\(]*):\\s*[\\[\\(](\\d+)[.,;]*\\s?(\\d+)?[\\]\\)]\\s*:?(?:\\[(\\w+)\\])?\\s*(.*)$";

    public JavacParser() {
        super(JAVAC_WARNING_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("[") || line.contains("w:");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String type = matcher.group(1);
        if ("ERROR".equals(type)) {
            builder.setSeverity(Severity.ERROR);
        } else {
            builder.setSeverity(Severity.WARNING_NORMAL);
        }
        String message = matcher.group(6);
        String category = Categories.guessCategoryIfEmpty(matcher.group(5), message);
        return builder.setFileName(matcher.group(2)).setLineStart(matcher.group(3)).setColumnStart(matcher.group(4)).setCategory(category).setMessage(message).buildOptional();
    }
}

