/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.util.ArrayDeque;
import java.util.Optional;
import java.util.regex.Matcher;
import org.apache.commons.lang3.StringUtils;

public class MavenConsoleParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = 1737791073711198075L;
    private static final String WARNING = "WARNING";
    private static final String ERROR = "ERROR";
    private static final int MAX_MESSAGE_LENGTH = 4000;
    private static final String PATTERN = "^(.*\\s\\s|)\\[(WARNING|ERROR)\\]\\s*(.*)$";

    public MavenConsoleParser() {
        super(PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains(WARNING) || line.contains(ERROR);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String errorOrWarningGroup = matcher.group(2);
        String errorOrWarningMessage = matcher.group(3);
        return builder.setLineStart(this.getCurrentLine()).setMessage(errorOrWarningMessage).setSeverity(this.extractSeverity(errorOrWarningGroup)).buildOptional();
    }

    private Severity extractSeverity(String errorOrWarningGroup) {
        if (ERROR.equals(errorOrWarningGroup)) {
            return Severity.ERROR;
        }
        return Severity.WARNING_NORMAL;
    }

    @Override
    protected Report postProcess(Report warnings) {
        IssueBuilder builder = new IssueBuilder();
        ArrayDeque<Issue> condensed = new ArrayDeque<Issue>();
        int line = -1;
        for (Issue warning : warnings) {
            if (warning.getLineStart() == line + 1 && !condensed.isEmpty()) {
                Issue previous = (Issue)condensed.getLast();
                if (previous.getSeverity().equals(warning.getSeverity())) {
                    condensed.removeLast();
                    if (previous.getMessage().length() + warning.getMessage().length() >= 4000) {
                        condensed.add(builder.copy(previous).setLineStart(warning.getLineStart()).build());
                    } else {
                        condensed.add(builder.copy(previous).setLineStart(warning.getLineStart()).setMessage(previous.getMessage() + "\n" + warning.getMessage()).build());
                    }
                } else {
                    condensed.add(warning);
                }
            } else {
                condensed.add(warning);
            }
            line = warning.getLineStart();
        }
        Report noBlank = new Report();
        for (Issue warning : condensed) {
            if (!StringUtils.isNotBlank((CharSequence)warning.getMessage())) continue;
            noBlank.add(warning);
        }
        return noBlank;
    }
}

