/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;

public class MetrowerksCwCompilerParser
extends RegexpLineParser {
    private static final long serialVersionUID = 4317595592384426180L;
    private static final String CW_COMPILER_WARNING_PATTERN = "^(.+?)\\((\\d+)\\): (INFORMATION|WARNING|ERROR) (.+?): (.*)$";

    public MetrowerksCwCompilerParser() {
        super(CW_COMPILER_WARNING_PATTERN);
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String category;
        Severity priority;
        if ("error".equalsIgnoreCase(matcher.group(3))) {
            priority = Severity.WARNING_HIGH;
            category = "ERROR";
        } else if ("information".equalsIgnoreCase(matcher.group(3))) {
            priority = Severity.WARNING_LOW;
            category = "Info";
        } else {
            priority = Severity.WARNING_NORMAL;
            category = "Warning";
        }
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(category).setMessage(matcher.group(5)).setSeverity(priority).buildOptional();
    }
}

