/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.FastRegexpLineParser;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;

public class PyLintParser
extends FastRegexpLineParser {
    private static final long serialVersionUID = 4464053085862883240L;
    private static final String PYLINT_ERROR_PATTERN = "(.*):(\\d+): \\[(\\D\\d*).*\\] (.*)";

    public PyLintParser() {
        super(PYLINT_ERROR_PATTERN);
    }

    @Override
    protected boolean isLineInteresting(String line) {
        return line.contains("[");
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String message = matcher.group(4);
        String category = Categories.guessCategoryIfEmpty(matcher.group(3), message);
        return builder.setFileName(matcher.group(1)).setLineStart(matcher.group(2)).setCategory(category).setMessage(message).setSeverity(this.mapPriorty(category)).buildOptional();
    }

    private Severity mapPriorty(String category) {
        Severity priority;
        switch (category.charAt(0)) {
            case 'C': 
            case 'R': {
                priority = Severity.WARNING_LOW;
                break;
            }
            case 'W': {
                priority = Severity.WARNING_NORMAL;
                break;
            }
            case 'E': 
            case 'F': {
                priority = Severity.WARNING_HIGH;
                break;
            }
            default: {
                priority = Severity.WARNING_LOW;
            }
        }
        return priority;
    }
}

