/*
 * Decompiled with CFR 0.152.
 */
package edu.hm.hafner.analysis.parser;

import edu.hm.hafner.analysis.Categories;
import edu.hm.hafner.analysis.Issue;
import edu.hm.hafner.analysis.IssueBuilder;
import edu.hm.hafner.analysis.ReaderFactory;
import edu.hm.hafner.analysis.RegexpLineParser;
import edu.hm.hafner.analysis.Report;
import edu.hm.hafner.analysis.Severity;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Stream;

public class RfLintParser
extends RegexpLineParser {
    private static final long serialVersionUID = -7903991158616386226L;
    private static final String RFLINT_ERROR_PATTERN = "([W|E|I]): (\\d+), (\\d+): (.*) \\((.*)\\)";
    private static final String RFLINT_FILE_PATTERN = "\\+\\s(.*)";
    private String fileName = "";

    public RfLintParser() {
        super(RFLINT_ERROR_PATTERN);
    }

    @Override
    public Report parse(ReaderFactory readerFactory) {
        try (Stream<String> lines = readerFactory.readStream();){
            Report warnings = new Report();
            Pattern filePattern = Pattern.compile(RFLINT_FILE_PATTERN);
            lines.forEach(line -> {
                Matcher matcher = filePattern.matcher((CharSequence)line);
                if (matcher.find()) {
                    this.fileName = matcher.group(1);
                }
                this.findIssues((String)line, warnings);
            });
            Report report = warnings;
            return report;
        }
    }

    @Override
    protected Optional<Issue> createIssue(Matcher matcher, IssueBuilder builder) {
        String message = matcher.group(4);
        String category = Categories.guessCategoryIfEmpty(matcher.group(1), message);
        Severity priority = Severity.WARNING_LOW;
        switch (category.charAt(0)) {
            case 'E': {
                priority = Severity.WARNING_HIGH;
                category = "ERROR";
                break;
            }
            case 'W': {
                priority = Severity.WARNING_NORMAL;
                category = "WARNING";
                break;
            }
            case 'I': {
                priority = Severity.WARNING_LOW;
                category = "IGNORE";
                break;
            }
        }
        return builder.setFileName(this.fileName).setLineStart(matcher.group(2)).setCategory(category).setMessage(message).setSeverity(priority).buildOptional();
    }
}

